/** 
 * @file    kPxPipe.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PX_PIPE_X_H
#define K_FIRESYNC_PX_PIPE_X_H

#include <kApi/Io/kPath.h>

typedef struct kPxPipeClass
{
    kObjectClass base; 
    k32u nodeId;                                //Node identifier. 
    kPxEnviron pipeEnviron;                     //Provides services from execution environment.
    kSize threadCount;                          //Desired processing thread count. 
} kPxPipeClass; 

typedef struct kPxPipeVTable
{
    kObjectVTable base; 
    
    kStatus (kCall* VSetMaxQueueSize)(kPxPipe pipe, kSize size);
    kStatus (kCall* VSetMaxQueueCount)(kPxPipe pipe, kSize count);
    kStatus (kCall* VClear)(kPxPipe pipe);
    kStatus (kCall* VAddBlocks)(kPxPipe pipe, const kPxBlock* blocks, kSize count);
    kStatus (kCall* VAddRoutes)(kPxPipe pipe, const kRouteEntry* routes, kSize count);
    kStatus (kCall* VStart)(kPxPipe pipe);
    kStatus (kCall* VEngage)(kPxPipe pipe);
    kStatus (kCall* VStop)(kPxPipe pipe);
    kStatus (kCall* VPause)(kPxPipe pipe);
    kStatus (kCall* VResume)(kPxPipe pipe);
    kStatus (kCall* VReplay)(kPxPipe pipe, kMsgInfo msgInfo);
    kStatus (kCall* VUpdateStats)(kPxPipe pipe); 

} kPxPipeVTable; 

kDeclareVirtualClassEx(kFs, kPxPipe, kObject)
        
kFsFx(kStatus) kPxPipe_Init(kPxPipe pipe, kType type, k32u nodeId, kPxEnviron pipeEnviron, kAlloc alloc);

kFsFx(kStatus) kPxPipe_VRelease(kPxPipe pipe);

kFsFx(kStatus) kPxPipe_VSetMaxQueueSize(kPxPipe pipe, kSize size); 
kFsFx(kStatus) kPxPipe_VSetMaxQueueCount(kPxPipe pipe, kSize count); 
kFsFx(kStatus) kPxPipe_VClear(kPxPipe pipe);
kFsFx(kStatus) kPxPipe_VAddBlocks(kPxPipe pipe, const kPxBlock* blocks, kSize count);
kFsFx(kStatus) kPxPipe_VAddRoutes(kPxPipe pipe, const kRouteEntry* routes, kSize count); 
kFsFx(kStatus) kPxPipe_VStart(kPxPipe pipe);
kFsFx(kStatus) kPxPipe_VEngage(kPxPipe pipe);
kFsFx(kStatus) kPxPipe_VStop(kPxPipe pipe);
kFsFx(kStatus) kPxPipe_VPause(kPxPipe pipe);
kFsFx(kStatus) kPxPipe_VResume(kPxPipe pipe);
kFsFx(kStatus) kPxPipe_VReplay(kPxPipe pipe, kMsgInfo msgInfo);
kFsFx(kStatus) kPxPipe_VUpdateStats(kPxPipe pipe);

#endif
