/** 
 * @file    kHxProjectorState.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_PROJECTOR_STATE_X_H
#define K_FIRESYNC_HX_PROJECTOR_STATE_X_H

typedef struct kHxProjectorStateVTable
{
    kObjectVTable base;
} kHxProjectorStateVTable;

typedef struct kHxProjectorStateClass
{
    kObjectClass base; 

    /* 
     * Read-only attributes established during init.
     */

    kHxProjector projector;         //Parent.
    kSize id;                       //Index of object in context of parent.

    /* 
     * Dynamic properties that are automatically initialized during init. 
     */

    k32u intensity;                 //Intensity setting. 
    k64u exposure;                  //Exposure setting (FS ns). 
    k64u gap;                       //Gap setting (FS ns).

} kHxProjectorStateClass; 

kDeclareVirtualClassEx(kFs, kHxProjectorState, kObject)

kFsFx(kStatus) xkHxProjectorState_Init(kHxProjectorState state, kType type, kProjector projector, kSize id, kAlloc alloc); 

kFsFx(kStatus) xkHxProjectorState_VRelease(kHxProjectorState state); 

#endif
