/** 
 * @file    kHxLight.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_LIGHT_X_H
#define K_FIRESYNC_HX_LIGHT_X_H

typedef struct kHxLightVTable
{
    kObjectVTable base; 

    kStatus (kCall* VClear)(kHxLight light);
    kStatus (kCall* VSetStateCount)(kHxLight light, kSize count);
    kStatus (kCall* VAddExtension)(kHxLight light, kLightExt extension);
    kStatus (kCall* VSetOutputState)(kHxLight light, kBool state);
    kStatus (kCall* VStats)(kHxLight light, kLightStats* stats);
    kStatus (kCall* VSetIntensity)(kHxLight light, k64f intensity);
    kStatus (kCall* VOverride)(kHxLight light, const kLightOverrideItem* overrides, kSize count);
    kStatus (kCall* VLockOut)(kHxLight light, kBool shouldLock);
    kStatus (kCall* VTrigger)(kHxLight light);

} kHxLightVTable;

typedef struct kHxLightClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                           //Parent.
    kSize index;                            //Index of this object in parent context.

    /* 
     * Read-only attributes that must be established by descendant during descendant init.
     */

    kLightCapability capabilities;          //Capabilities bitset. 
    kLdModel info;                          //Light information object. 

    /* 
     * Dynamic properties that can be re/initialized by calling Clear method from descendant. 
     */

    kBool enabled;                          //Light enabled setting.
    kLightControl controlType;              //Control mode setting.
    kSize controlId;                        //Control id setting.

    k64f intensity;                         //Light intensity (normalized).
    k64f minIntensity;                      //Minimum supported light intensity (normalized).

    kLightMask mask;                        //Light mask source type setting.    
    k32u maskId;                            //Light mask source id setting.
    kBool maskPolarity;                     //Light mask polarity setting.

    kBool powerSaverEnabled;                //Power saver enabled setting.

    kArrayList states;                      //Light states; list constructed by base, elements added by descendant -- kArrayList<kHxLightState>.
    kArrayList extensions;                  //Light control extensions; list constructed by base, elements added by descendant -- kArrayList<kHxLightExt>.

} kHxLightClass;

kDeclareVirtualClassEx(kFs, kHxLight, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxLight_Init(kHxLight light, kType type, kHxNode node, kSize index, kAlloc alloc); 

kFsFx(kStatus) xkHxLight_VRelease(kHxLight light); 

kInlineFx(kStatus) xkHxLight_VSetStateCount(kHxLight light, kSize count)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxLight_VAddExtension(kHxLight light, kLightExt extension)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxLight_VSetOutputState(kHxLight light, kBool state)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxLight_VStats(kHxLight light, kLightStats* stats)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxLight_VSetIntensity(kHxLight light, k64f intensity)
{
    kObj(kHxLight, light); 

    obj->intensity = intensity; 
        
    return kOK;
}

kInlineFx(kStatus) xkHxLight_VTrigger(kHxLight light)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxLight_VOverride(kHxLight light, const kLightOverrideItem* overrides, kSize count)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxLight_VLockOut(kHxLight light, kBool shouldLock)
{
    return kERROR_UNIMPLEMENTED;
}

//can optionally be overridden, but probably doesn't need to be
kFsFx(kStatus) xkHxLight_VClear(kHxLight light);

#endif
