/** 
 * @file    kHxGpio.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_GPIO_X_H
#define K_FIRESYNC_HX_GPIO_X_H

kDeclareValueEx(kFs, kHxGpioPin, kValue)

typedef struct kHxGpioVTable
{
    kObjectVTable base; 

    kStatus (kCall* VSetEventHandler)(kHxGpio gpio, kCallbackFx function, kPointer receiver, kAlloc eventAlloc);
    kSize (kCall* VBankCount)(kHxGpio gpio);
    kGpioBankType (kCall* VBankType)(kHxGpio gpio, kSize bankIndex);
    kSize (kCall* VPinCount)(kHxGpio gpio, kSize bankIndex);
    kStatus (kCall* VEnableEvents)(kHxGpio gpio, kSize bankIndex, kSize pinIndex, kBool enabled);
    kBool (kCall* VEventsEnabled)(kHxGpio gpio, kSize bankIndex, kSize pinIndex);
    kStatus (kCall* VSetState)(kHxGpio gpio, kSize bankIndex, k64u mask, k64u state);
    kStatus (kCall* VGetState)(kHxGpio gpio, kSize bankIndex, k64u* state);
    kStatus (kCall* VSetPinConfig)(kHxGpio gpio, kSize bankIndex, kArrayList pinConfig);
    kStatus (kCall* VGetPinConfig)(kHxGpio gpio, kSize bankIndex, kArrayList pinConfig);

} kHxGpioVTable;

typedef struct kHxGpioClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                           //Parent.
   
} kHxGpioClass;

kDeclareVirtualClassEx(kFs, kHxGpio, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxGpio_Init(kHxGpio gpio, kType type, kHxNode node, kAlloc alloc); 

kFsFx(kStatus) xkHxGpio_VRelease(kHxGpio gpio); 

kInlineFx(kStatus) xkHxGpio_VSetEventHandler(kHxGpio gpio, kCallbackFx function, kPointer receiver, kAlloc eventAlloc)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kSize) xkHxGpio_VBankCount(kHxGpio gpio)
{
    return 0;
}

kInlineFx(kGpioBankType) xkHxGpio_VBankType(kHxGpio gpio, kSize bankIndex)
{
    return kGPIO_BANK_TYPE_UNKNOWN;
}

kInlineFx(kSize) xkHxGpio_VPinCount(kHxGpio gpio, kSize bankIndex)
{
    return 0;
}

kInlineFx(kStatus) xkHxGpio_VEnableEvents(kHxGpio gpio, kSize bankIndex, kSize pinIndex, kBool enabled)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kBool) xkHxGpio_VEventsEnabled(kHxGpio gpio, kSize bankIndex, kSize pinIndex)
{
    return kFALSE;
}

kInlineFx(kStatus) xkHxGpio_VSetState(kHxGpio gpio, kSize bankIndex, k64u mask, k64u state)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxGpio_VGetState(kHxGpio gpio, kSize bankIndex, k64u* state)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxGpio_VSetPinConfig(kHxGpio gpio, kSize bankIndex, kArrayList pinConfig)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxGpio_VGetPinConfig(kHxGpio gpio, kSize bankIndex, kArrayList pinConfig)
{
    return kERROR_UNIMPLEMENTED;
}

#endif
