/** 
 * @file    kHxEvent.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_EVENT_X_H
#define K_FIRESYNC_HX_EVENT_X_H

typedef struct kHxEventVTable
{
    kObjectVTable base; 

    kStatus (kCall* VSchedule)(kHxEvent manager, k64s target);
    kStatus (kCall* VTrigger)(kHxEvent manager);
    kStatus (kCall* VStats)(kHxEvent manager, kEventStats* stats);
    kStatus (kCall* VClear)(kHxEvent manager);

} kHxEventVTable;

typedef struct kHxEventClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                       //Parent.
    kSize index;                        //Index of this object in parent context.

    /* 
     * Read-only attributes that must be established by descendant during descendant init.
     */

    kEventManagerType eventType;        //Event manager type.

    /* 
     * Dynamic properties that can be re/initialized by calling Clear method from descendant. 
     */

    kBool enabled;                      //Event enabled setting.
    kEventControl controlType;          //Control mode setting.
    kSize controlId;                    //Control id setting.
    kSyncDomain domain;                 //Domain setting.
    kEventEncoder encoderMode;          //Encoder mode setting.
    k64u offset;                        //Offset setting.
    k64u period;                        //Period setting.
    k64u count;                         //Count setting.    
    kBool gateEnabled;                  //Gate enabled setting.
    kEventMissStyle missStyle;          //Miss style setting.
    kBool cancellationEnabled;          //Event sequence cancellation enabled setting.


    /* 
     * Implementation helper fields. 
     */
    k32u phase;                         //Previous phase; used for start-scheduling during recovery.

} kHxEventClass;

kDeclareVirtualClassEx(kFs, kHxEvent, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxEvent_Init(kHxEvent manager, kType type, kHxNode node, kSize index, kAlloc alloc); 

kFsFx(kStatus) xkHxEvent_VRelease(kHxEvent manager); 

kInlineFx(kStatus) xkHxEvent_VSchedule(kHxEvent manager, k64s target)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxEvent_VSetOutputState(kHxEvent manager, kBool state)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxEvent_VStats(kHxEvent manager, kEventStats* stats)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxEvent_VTrigger(kHxEvent manager)
{
    return kERROR_UNIMPLEMENTED;
}

//can optionally be overridden, but probably doesn't need to be
kFsFx(kStatus) xkHxEvent_VClear(kHxEvent manager);

#endif
