/** 
 * @file    kHxDigitalOut.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_DIGITAL_OUT_X_H
#define K_FIRESYNC_HX_DIGITAL_OUT_X_H

typedef struct kHxDigitalOutVTable
{
    kObjectVTable base; 

    kStatus (kCall* VSetOutputState)(kHxDigitalOut digital, kBool state);
    kStatus (kCall* VStats)(kHxDigitalOut digital, kDigitalOutStats* stats);
    kStatus (kCall* VTrigger)(kHxDigitalOut digital);
    kStatus (kCall* VClear)(kHxDigitalOut digital);

} kHxDigitalOutVTable;

typedef struct kHxDigitalOutClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                       //Parent.
    kSize index;                        //Index of this object in parent context.

    /* 
     * Dynamic properties that can be re/initialized by calling Clear method from descendant. 
     */

    kBool enabled;                      //DigitalOut enabled setting.
    kDigitalOutControl controlType;     //Control mode setting.
    kSize controlId;                    //Control id setting.

    kBool polarity;                     //Is active high?
    k64u delay;                         //Delay setting (fs ns). 
    k64u exposure;                      //Exposure setting (fs ns). 
    k64u gap;                           //Gap setting (fs ns). 

} kHxDigitalOutClass;

kDeclareVirtualClassEx(kFs, kHxDigitalOut, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxDigitalOut_Init(kHxDigitalOut digital, kType type, kHxNode node, kSize index, kAlloc alloc); 

kFsFx(kStatus) xkHxDigitalOut_VRelease(kHxDigitalOut digital); 


kInlineFx(kStatus) xkHxDigitalOut_VSetOutputState(kHxDigitalOut digital, kBool state)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxDigitalOut_VStats(kHxDigitalOut digital, kDigitalOutStats* stats)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxDigitalOut_VTrigger(kHxDigitalOut digital)
{
    return kERROR_UNIMPLEMENTED;
}

//can optionally be overridden, but probably doesn't need to be
kFsFx(kStatus) xkHxDigitalOut_VClear(kHxDigitalOut digital);

#endif
