/** 
 * @file    kHxDigitalOut.h
 * @brief   Declares the kHxDigitalOut class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_DIGITAL_OUT_H
#define K_FIRESYNC_HX_DIGITAL_OUT_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/kHxDigitalOut.x.h>

/**
 * @class       kHxDigitalOut
 * @extends     kObject
 * @ingroup     kFireSync-Hardware
 * @internal
 * @brief       Abstract base class for hardware digital output classes.
 */
//typedef kObject kHxDigitalOut;      --forward-declared in kFsDef.x.h

kInlineFx(kHxNode) kHxDigitalOut_Node(kHxDigitalOut digital)
{
    kObj(kHxDigitalOut, digital); 

    return obj->node;
}

kInlineFx(kSize) kHxDigitalOut_Index(kHxDigitalOut digital)
{
    kObj(kHxDigitalOut, digital); 

    return obj->index;
}

kInlineFx(kStatus) kHxDigitalOut_Enable(kHxDigitalOut digital, kBool enabled)
{
    kObj(kHxDigitalOut, digital); 

    obj->enabled = enabled; 

    return kOK; 
}

kInlineFx(kBool) kHxDigitalOut_IsEnabled(kHxDigitalOut digital)
{
    kObj(kHxDigitalOut, digital); 

    return obj->enabled; 
}

kInlineFx(kStatus) kHxDigitalOut_SetControl(kHxDigitalOut digital, kDigitalOutControl type)
{
    kObj(kHxDigitalOut, digital); 

    obj->controlType = type; 

    return kOK; 
}

kInlineFx(kDigitalOutControl) kHxDigitalOut_Control(kHxDigitalOut digital)
{
    kObj(kHxDigitalOut, digital); 

    return obj->controlType; 
}

kInlineFx(kStatus) kHxDigitalOut_SetControlId(kHxDigitalOut digital, kSize id)
{
    kObj(kHxDigitalOut, digital); 

    obj->controlId = id; 

    return kOK; 
}

kInlineFx(kSize) kHxDigitalOut_ControlId(kHxDigitalOut digital)
{
    kObj(kHxDigitalOut, digital); 

    return obj->controlId; 
}

kInlineFx(kStatus) kHxDigitalOut_SetPolarity(kHxDigitalOut digital, kBool polarity)
{
    kObj(kHxDigitalOut, digital);

    obj->polarity = polarity; 

    return kOK; 
}

kInlineFx(kBool) kHxDigitalOut_Polarity(kHxDigitalOut digital)
{
    kObj(kHxDigitalOut, digital);

    return obj->polarity;
}

kInlineFx(kStatus) kHxDigitalOut_SetDelay(kHxDigitalOut digital, k64u delay)
{
    kObj(kHxDigitalOut, digital);

    obj->delay = delay; 

    return kOK; 
}

kInlineFx(k64u) kHxDigitalOut_Delay(kHxDigitalOut digital)
{
    kObj(kHxDigitalOut, digital);

    return obj->delay;
}

kInlineFx(kStatus) kHxDigitalOut_SetExposure(kHxDigitalOut digital, k64u exposure)
{
    kObj(kHxDigitalOut, digital);

    obj->exposure = exposure; 

    return kOK; 
}

kInlineFx(k64u) kHxDigitalOut_Exposure(kHxDigitalOut digital)
{
    kObj(kHxDigitalOut, digital);

    return obj->exposure; 
}

kInlineFx(kStatus) kHxDigitalOut_SetGap(kHxDigitalOut digital, k64u gap)
{
    kObj(kHxDigitalOut, digital);

    obj->gap = gap; 

    return kOK; 
}

kInlineFx(k64u) kHxDigitalOut_Gap(kHxDigitalOut digital)
{
    kObj(kHxDigitalOut, digital);

    return obj->gap;
}

kInlineFx(kStatus) kHxDigitalOut_SetOutputState(kHxDigitalOut digital, kBool state)
{
    return xkHxDigitalOut_VTable(digital)->VSetOutputState(digital, state);
}

kInlineFx(kStatus) kHxDigitalOut_Stats(kHxDigitalOut digital, kDigitalOutStats* stats)
{
    return xkHxDigitalOut_VTable(digital)->VStats(digital, stats);
}

kInlineFx(kStatus) kHxDigitalOut_Trigger(kHxDigitalOut digital)
{
    return xkHxDigitalOut_VTable(digital)->VTrigger(digital);
}

kInlineFx(kStatus) kHxDigitalOut_Clear(kHxDigitalOut digital)
{
    return xkHxDigitalOut_VTable(digital)->VClear(digital);
}

#endif
