/** 
 * @file    kHxLightExt.h
 * @brief   Declares the kHxLightExt class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_LIGHT_EXT_H
#define K_FIRESYNC_HX_LIGHT_EXT_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/Light/kHxLightExt.x.h>

/**
 * @class       kHxLightExt
 * @extends     kObject
 * @ingroup     kFireSync-Hardware-Light
 * @internal
 * @brief       Abstract base class for hardware light extension classes.
 */
//typedef kObject kHxLightExt;      --forward-declared in kFsDef.x.h


kInlineFx(kStatus) kHxLightExt_Override(kHxLightExt ext, const kLightOverrideItem* overrides, kSize count)
{
    return xkHxLightExt_VTable(ext)->VOverride(ext, overrides, count);
}

kInlineFx(kLightExt) kHxLightExt_Config(kHxLightExt ext)
{
    kObj(kHxLightExt, ext); 

    return obj->config;
}


#endif
