/** 
 * @file    kTerrain.h
 * @brief   Declares the kTerrain class.
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_TERRAIN_H
#define K_FIRESYNC_TERRAIN_H

#include <kFireSync/kFsDef.h>
#include <kFireSync/Data/kTerrain.x.h>

//typedef kObject kTerrain;            --forward-declared in kFsDef.x.h

kFsFx(kStatus) kTerrain_Construct(kTerrain* terrain, kImage profile, kAlloc allocator);

kFsFx(kImage) kTerrain_GetProfile(kTerrain terrain);
kFsFx(kStatus) kTerrain_SetProfile(kTerrain terrain,kImage image);

kFsFx(kStatus) kTerrain_AddOverlay(kTerrain terrain,kImage image);
kFsFx(kImage*) kTerrain_OverlayAt(kTerrain terrain,k32u index);
kFsFx(kStatus) kTerrain_ClearOverlays(kTerrain terrain);
kFsFx(kSize) kTerrain_OverlayCount(kTerrain terrain);

kFsFx(kStatus) kTerrain_SetWorldPlane(kTerrain terrain,kPoint3d32s * topLeft,kPoint3d32s * bottomLeft,kPoint3d32s * bottomRight);
kFsFx(kStatus) kTerrain_GetWorldPlane(kTerrain terrain,kPoint3d32s * topLeft,kPoint3d32s * bottomLeft,kPoint3d32s * bottomRight);

kFsFx(kStatus) kTerrain_InvertProfile(kTerrain terrain,kBool invert);
kFsFx(kStatus) kTerrain_IsProfileInverted(kTerrain terrain,kBool *inverted);

#endif
