/** 
 * @file    kSpot.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_SPOT_X_H
#define K_FIRESYNC_SPOT_X_H

/* 
 * kSpot
 */

kDeclareValueEx(kFs, kSpot, kValue)

kFsFx(kStatus) kSpot_Write5(kType type, const void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kSpot_Read5(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kSpot_Write6(kType type, const void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kSpot_Read6(kType type, void* values, kSize count, kSerializer serializer);

/* 
 * kSpot2
 */

kDeclareValueEx(kFs, kSpot2, kValue)

kFsFx(kStatus) kSpot2_Write5(kType type, const void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kSpot2_Read5(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kSpot2_Write6(kType type, const void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kSpot2_Read6(kType type, void* values, kSize count, kSerializer serializer);

/* 
 * kFpgaCSum
 */

kDeclareValueEx(kFs, kFpgaCSum, kValue)

kFsFx(kStatus) kFpgaCSum_Write5(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaCSum_Read5(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaCSum_Write6(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaCSum_Read6(kType type, void* values, kSize count, kSerializer serializer);

/* 
 * kFpgaCSum3
 */
kDeclareValueEx(kFs, kFpgaCSum3, kValue)

#define kFPGA_CSUM3_OVERFLOW_MASK       (0x80000000)
#define kFPGA_CSUM3_WSUM_MASK           (0x7FFFF000)
#define kFPGA_CSUM3_WSUM_SHIFT          (12)
#define kFPGA_CSUM3_SUM_MASK            (0x00000FFF)
#define kFPGA_CSUM3_SUM_SHIFT           (0)

kFsFx(kStatus) kFpgaCSum3_Write5(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaCSum3_Read5(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaCSum3_Write6(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaCSum3_Read6(kType type, void* values, kSize count, kSerializer serializer);

/* 
 * kCSum4
 */
kDeclareValueEx(kFs, kCSum4, kValue)

#define kCSUM4_OVERFLOW            (k32U_NULL)
#define kCSUM4_WSUM_MASK           (0xFFFFE000u)
#define kCSUM4_WSUM_SHIFT          (13u)
#define kCSUM4_SUM_MASK            (0x00001FFFu)
#define kCSUM4_SUM_SHIFT           (0u)

kFsFx(kStatus) kCSum4_Write6(kType type, void* values, kSize count, kSerializer serializer); 
kFsFx(kStatus) kCSum4_Read6(kType type, void* values, kSize count, kSerializer serializer); 

/* 
 * kPhasePixel
 */
kDeclareValueEx(kFs, kPhasePixel, kValue)

kFsFx(kStatus) kPhasePixel_Write6(kType type, void* values, kSize count, kSerializer serializer); 
kFsFx(kStatus) kPhasePixel_Read6(kType type, void* values, kSize count, kSerializer serializer); 

/* 
 * kPhasePixel2
 */
kDeclareValueEx(kFs, kPhasePixel2, kValue)

#define kPHASE_PIXEL2_INTENSITY_MASK    (0xFF000000)
#define kPHASE_PIXEL2_INTENSITY_SHIFT   (24)

#define kPHASE_PIXEL2_PHASE_MASK        (0x00FFFFFF)
#define kPHASE_PIXEL2_PHASE_SHIFT       (0)

kFsFx(kStatus) kPhasePixel2_Write6(kType type, const void* values, kSize count, kSerializer serializer); 
kFsFx(kStatus) kPhasePixel2_Read6(kType type, void* values, kSize count, kSerializer serializer); 

/* 
 * kFpgaSpot
 */

kDeclareValueEx(kFs, kFpgaSpot, kValue)

#define kxFPGA_SPOT_MISC_EMPTY_MASK                    (0x8000)      
#define kxFPGA_SPOT_MISC_ORIENT_MASK                   (0x4000)
#define kxFPGA_SPOT_MISC_SUM_MASK                      (0x1FFF)
#define kxFPGA_SPOT_MISC_SUM_SHIFT                     (0)
#define kxFPGA_SPOT_CENTER_MASK1                       (0x000FFFFF)
#define kxFPGA_SPOT_CENTER_SIZE1                       (20)
#define kxFPGA_SPOT_CENTER_MASK2                       (0x60000000)
#define kxFPGA_SPOT_CENTER_SHIFT2                      (29)
#define kxFPGA_SPOT_SLICE_MASK1                        (0x0FFF)
#define kxFPGA_SPOT_SLICE_SIZE1                        (12)
#define kxFPGA_SPOT_SLICE_MASK2                        (0x6000)
#define kxFPGA_SPOT_SLICE_SHIFT2                       (13)
#define kxFPGA_SPOT_SPOT_WIDTH_MASK                    (0x1F000000)
#define kxFPGA_SPOT_SPOT_WIDTH_SHIFT                   (24)
#define kxFPGA_SPOT_SOBEL_ENTRY_VALUE_MASK1            (0xF000)
#define kxFPGA_SPOT_SOBEL_ENTRY_VALUE_SHIFT1           (8)
#define kxFPGA_SPOT_SOBEL_ENTRY_VALUE_MASK2            (0x00F00000)
#define kxFPGA_SPOT_SOBEL_ENTRY_VALUE_SHIFT2           (20)
#define kxFPGA_SPOT_SOBEL_ENTRY_OFFSET_FRACTIONAL_BITS (1)
#define kxFPGA_SPOT_SOBEL_EXIT_OFFSET_FRACTIONAL_BITS  (1)

kFsFx(kStatus) kFpgaSpot_Write5(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaSpot_Read5(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaSpot_Write6(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaSpot_Read6(kType type, void* values, kSize count, kSerializer serializer);

/* 
 * kFpgaWideSpot
 */

kDeclareValueEx(kFs, kFpgaWideSpot, kValue)

#define kxFPGA_WIDE_SPOT_MISC_EMPTY_MASK            (0x8000)
#define kxFPGA_WIDE_SPOT_MISC_ORIENT_MASK           (0x4000)
#define kxFPGA_WIDE_SPOT_MISC_SUM_MASK              (0x1FFF)
#define kxFPGA_WIDE_SPOT_MISC_SUM_SHIFT             (0)
#define kxFPGA_WIDE_SPOT_CENTER_MASK1               (0x000FFFFF)
#define kxFPGA_WIDE_SPOT_CENTER_SIZE1               (20)
#define kxFPGA_WIDE_SPOT_CENTER_MASK2               (0x60000000)
#define kxFPGA_WIDE_SPOT_CENTER_SHIFT2              (29)
#define kxFPGA_WIDE_SPOT_SLICE_MASK1                (0x0FFF)
#define kxFPGA_WIDE_SPOT_SLICE_SIZE1                (12)
#define kxFPGA_WIDE_SPOT_SLICE_MASK2                (0x6000)
#define kxFPGA_WIDE_SPOT_SLICE_SHIFT2               (13)
#define kxFPGA_WIDE_SPOT_SPOT_WIDTH_MASK            (0x1F000000)
#define kxFPGA_WIDE_SPOT_SPOT_WIDTH_SHIFT           (24)
#define kxFPGA_WIDE_SPOT_SOBEL_SPARE_MASK1          (0xF000)
#define kxFPGA_WIDE_SPOT_SOBEL_SPARE_SHIFT1         (8)
#define kxFPGA_WIDE_SPOT_SOBEL_SPARE_MASK2          (0x00F00000)
#define kxFPGA_WIDE_SPOT_SOBEL_SPARE_SHIFT2         (20)

#define kxFPGA_WIDE_SPOT_SOBEL_ENTRY_OFFSET_FRACTIONAL_BITS   (1)
#define kxFPGA_WIDE_SPOT_SOBEL_EXIT_OFFSET_FRACTIONAL_BITS    (1)


#define kxFPGA_WIDE_SPOT_MULTIPLIER_SHIFT           (2)

kFsFx(kStatus) kFpgaWideSpot_Write5(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaWideSpot_Read5(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaWideSpot_Write6(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kFpgaWideSpot_Read6(kType type, void* values, kSize count, kSerializer serializer);

kDeclareValueEx(kFs, kFpgaSpot2i, kValue)

kFsFx(kStatus) xkFpgaSpot2i_Write(kType type, const void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) xkFpgaSpot2i_Read(kType type, void* values, kSize count, kSerializer serializer);

/* 
* Deprecated (Stage 1): not recommended for further use, but not yet announced via kDeprecate
*/

//Deprecated: use kFpgaWideSpot_Centre
#define kFpgaWideSpot_Center kFpgaWideSpot_Centre
//kDeprecate(kFpgaWideSpot_Center)

//Deprecated: use kFpgaWideSpot_Width
#define kFpgaWideSpot_SpotWidth kFpgaWideSpot_Width
//kDeprecate(kFpgaWideSpot_SpotWidth)

//Deprecated: use kFpgaWideSpot_Width
#define kFpgaWideSpot_Empty kFpgaWideSpot_IsEmpty
//kDeprecate(kFpgaWideSpot_Empty)

/*
* Generic utility methods
*/

kFsFx(k8u) kSpot_GetPixel(kImage image, k32s x, k32s y);

kFsFx(kStatus) kSpot_SobelAccgPl61(kImage image, k32u averageWindow, k32u edgeWindow, k32u threshold, k32u widthThreshold, k32u minWidth,
    k32u maxWidth, k32u minSum, kArrayList spots, kArrayList bounds, kImage edgeImage);

typedef struct kSpotSobelAccgState
{
    kPoint32s boundary;
    k32s wsum;
    k32s sum;
    kBool inSpot;
    k32s gradientState;
    k32s gradientStatePrev;
    k32s spotBegin;
    k32s intensityBase;
    k32s intensityPrev;
    k32s width;
} kSpotSobelAccgState;

/**
 * Per-column state struct used for SobelvZc algorithm
 */
struct kSpot_SobelvZcState
{
    k16s lastPositiveGradient;   /*Last positive gradient value before gradient becomes <= 0*/
    kSize lastPositiveIndex;     /*Index of last positive gradient*/
    kBool inSpot;                /*Whether column is within a spot at current row*/
    kBool mismatchedColumn;      /*Whether column has mismatched spot entrances and exits, i.e. is 'bad'*/
};

/**
 * Zero crossing and interpolation for Focalspec moving average + zero crossing spot detection algorithm
 * This function is designed to be wrapped by `kSpot_SobelvZc`
 *
 * @param  edgeImage        Image with gradient crossing filter applied
 * @param  detectionImage   Image with spot detection moving sum filter applied
 * @param  intensityImage   Image with spot intensity moving sum filter applied
 * @param  spots            kArrayList of type kSpot. Will be zeroed out and populated up to its capacity
 * @param  edgeWindow       Size of filter used for gradient filter
 * @param  averageWindow    Size of moving average filter used to determine weather a pixel is inside a spot
 * @param  intensityWindow  Size of moving average filter used to determine spot intensity
 * @param  threshold        Threshold against which detection filtered pixel is compared to determine if it is inside a spot
 * @param  colStateArray    Temporary array of MovingAverageZCState. Must have size >= Input Image Width
 */
kFsFx(kStatus) kSpot_SobelvZcEx(
    kImage edgeImage, kImage detectionImage, kImage intensityImage,  kArrayList spots,
    kSize edgeWindow, kSize averageWindow, kSize intensityWindow, k16u threshold,
    kArray1 colStateArray);

/**
 * Apply one sided moving sum filter to all columns of input image.
 * Input image is black-padded.
 *
 * Example filter size -> Filter kernel; maxFilterSize = 10
 * 4 -> [0  0  0  1  1  1  1  0  0  0]
 * 6 -> [0  0  1  1  1  1  1  1  0  0]
 * 8 -> [0  1  1  1  1  1  1  1  1  0]
 *
 * Example filter size -> Filter kernel; maxFilterSize = 12
 * 4 -> [0  0  0  0  1  1  1  1  0  0  0  0]
 * 6 -> [0  0  0  1  1  1  1  1  1  0  0  0]
 * 8 -> [0  0  1  1  1  1  1  1  1  1  0  0]
 *
 * @param input          Input Image with pixel type k8u
 * @param filterSize     Size of (one sided) moving sum filter to apply
 * @param maxfilterSize  Maximum filter size being used (controls offset of data)
 * @param output         Output image with pixel type k16u
 * @returns kStatus
 */
kFsFx(kStatus) kSpot_OneSidedMovingSumFilter(kImage input, kSize filterSize, kSize maxFilterSize, kImage output);


/**
 * Apply one sided gradient filter to all columns of input image.
 * Input image is black-padded.
 *
 * Example filter size -> Filter kernel; maxFilterSize = 10
 * 4 -> [0  0  0 -1 -1  1  1  0  0  0]
 * 6 -> [0  0 -1 -1 -1  1  1  1  0  0]
 * 8 -> [0 -1 -1 -1 -1  1  1  1  1  0]
 *
 * Example filter-size -> Filter kernel; maxFilterSize = 12
 * 4 -> [0  0  0  0 -1 -1  1  1  0  0  0  0]
 * 6 -> [0  0  0 -1 -1 -1  1  1  1  0  0  0]
 * 8 -> [0  0 -1 -1 -1 -1  1  1  1  1  0  0]
 *
 * @param input       Input image with pixel type k64f
 * @param filterSize  Size of (one sided) gradient filter to apply
 * @param maxfilterSize  Maximum filter size being used (controls offset of data)
 * @param output      Output image with pixel type k16s
 *
 * @returns kStatus
 */
kFsFx(kStatus) kSpot_OneSidedGradientFilter(kImage input, kSize filterSize, kSize maxFilterSize, kImage output);


#endif
