#ifndef K_FIRESYNC_PROPERTY_LIST_H
#define K_FIRESYNC_PROPERTY_LIST_H

#include <kFireSync/kFsDef.h>

//typedef kObject kPropertyList;            --forward-declared in kFsDef.x.h

kDeclareClassEx(kFs, kPropertyList, kObject)
kDeclareValueEx(kFs, kPropertyListProperty, kValue)

kFsFx(kStatus) kPropertyList_Construct(kPropertyList* id, kAlloc alloc);

kFsFx(kStatus) kPropertyList_Read(kPropertyList id, kXml xml);
kFsFx(kStatus) kPropertyList_Write(kPropertyList id, kXml xml);

kFsFx(kStatus) kPropertyList_SetText(kPropertyList id, const kChar* name, const kChar* value);
kFsFx(kStatus) kPropertyList_SetInt(kPropertyList id, const kChar* name, k64s value);
kFsFx(kStatus) kPropertyList_SetFloat(kPropertyList id, const kChar* name, k64f value);
kFsFx(kStatus) kPropertyList_SetVersion(kPropertyList id, const kChar* name, kVersion version);

kFsFx(kStatus) kPropertyList_Delete(kPropertyList id, const kChar* name);
kFsFx(kStatus) kPropertyList_Clear(kPropertyList id);

kFsFx(kSize) kPropertyList_Count(kPropertyList id);
kFsFx(const kChar*) kPropertyList_NameAt(kPropertyList id, kSize index);

kFsFx(kBool) kPropertyList_Exists(kPropertyList id, const kChar* name);
kFsFx(const kChar*) kPropertyList_Text(kPropertyList id, const kChar* name);
kFsFx(k64s) kPropertyList_Int(kPropertyList id, const kChar* name);
kFsFx(k64f) kPropertyList_Float(kPropertyList id, const kChar* name);
kFsFx(kVersion) kPropertyList_Version(kPropertyList id, const kChar* name);

#endif
