/** 
 * @file    kProfileMsg.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROFILE_MSG_X_H
#define K_FIRESYNC_PROFILE_MSG_X_H

#define kPROFILE_MSG_ALIGNMENT      (3)          //align profile to 8-byte boundaries

typedef struct kProfileMsgRef
{
    kStamp* stamp; 
    void* pointData; 
    k8u* intensities; 
    k16u* slices;
} kProfileMsgRef; 

typedef struct kProfileMsgClass
{
    kMsgSetClass base; 
    void* buffer;
    kSize allocSize;
    kType pointType;
    kSize pointCount;
    kSize profileCount;
    kBool allocData;
    kBool hasSlices;
} kProfileMsgClass; 

kDeclareClassEx(kFs, kProfileMsg, kMsgSet)
        
/*
* Forward declarations
*/

kInlineFx(kType) kProfileMsg_PointType(kProfileMsg msg);
kInlineFx(void*) kProfileMsg_PointAt(kProfileMsg msg, kSize itemIndex, kSize pointIndex);

/*
* Private methods
*/

kFsFx(kStatus) kProfileMsg_Init(kProfileMsg msg, kType type, kType pointType, kSize pointCount, kSize profileCount, kBool hasSlices, kAlloc alloc);
kFsFx(kStatus) xkProfileMsg_ConstructFramework(kProfileMsg* msg, kAlloc allocator); 
kFsFx(kStatus) xkProfileMsg_InitFramework(kProfileMsg msg, kType type, kAlloc alloc);
kFsFx(kStatus) kProfileMsg_VRelease(kProfileMsg msg);
kFsFx(kStatus) kProfileMsg_VClone(kProfileMsg msg, kProfileMsg other, kAlloc valueAlloc, kObject context); 
kFsFx(kSize) kProfileMsg_VSize(kProfileMsg msg);

kFsFx(kSize) kProfileMsg_VCount(kProfileMsg msg);
kFsFx(const kStamp*) kProfileMsg_VStampAt(kProfileMsg msg, kSize index);
kFsFx(kStatus) kProfileMsg_VSetStampAt(kProfileMsg msg, kSize index, const kStamp* stamp);
kFsFx(kStatus) kProfileMsg_VDataAt(kProfileMsg msg, kSize index, kArrayList* list);

kFsFx(kStatus) xkProfileMsg_WriteDat6V0(kProfileMsg msg, kSerializer serializer);
kFsFx(kStatus) xkProfileMsg_WriteDat6V1(kProfileMsg msg, kSerializer serializer);
kFsFx(kStatus) xkProfileMsg_WriteDat6V2(kProfileMsg msg, kSerializer serializer);
kFsFx(kStatus) xkProfileMsg_ReadDat6V0(kProfileMsg msg, kSerializer serializer);
kFsFx(kStatus) xkProfileMsg_ReadDat6V1(kProfileMsg msg, kSerializer serializer);
kFsFx(kStatus) xkProfileMsg_ReadDat6V2(kProfileMsg msg, kSerializer serializer);

kFsFx(kStatus) kProfileMsg_Realloc(kProfileMsg msg);
kFsFx(kStatus) kProfileMsg_Allocate(kProfileMsg msg, kType pointType, kSize pointCount, kSize profileCount, kBool hasSlices);
kFsFx(kStatus) kProfileMsg_BufferInit(kProfileMsg msg);

kFsFx(kSize) kProfileMsg_ProfileSize(kProfileMsg msg);
kFsFx(kSize) kProfileMsg_StampSize(kProfileMsg msg);
kFsFx(kSize) kProfileMsg_RangesSize(kProfileMsg msg);
kFsFx(kSize) kProfileMsg_IntensitiesSize(kProfileMsg msg);
kFsFx(kSize) kProfileMsg_SlicesSize(kProfileMsg msg);
kFsFx(kSize) kProfileMsg_DataSize(kProfileMsg msg);
kFsFx(kSize) kProfileMsg_RefSize(kProfileMsg msg);
kFsFx(kSize) kProfileMsg_RequiredSize(kProfileMsg msg);

#define kProfileMsg_Buffer_(MSG)                        (xkProfileMsg_Cast(MSG)->buffer)

kInlineFx(kProfileMsgRef*) xkProfileMsg_RefAt(kProfileMsg msg, kSize index)
{
    kObj(kProfileMsg, msg); 
    kProfileMsgRef* buffer = (kProfileMsgRef*) obj->buffer;

    kAssert(index < obj->profileCount); 

    return &buffer[index]; 
}

kInlineFx(void*) xkProfileMsg_PointAtT(kProfileMsg msg, kSize itemIndex, kSize pointIndex, kSize itemSize)
{
    kAssert(xkType_IsPointerCompatible(kProfileMsg_PointType(msg), itemSize)); 

    return kProfileMsg_PointAt(msg, itemIndex, pointIndex);
} 

#endif
