/** 
 * @file    kMsg.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MSG_X_H
#define K_FIRESYNC_MSG_X_H

typedef struct kMsgClass
{
    kMsgSetClass base; 
    kStamp stamp;
    kObject data;
} kMsgClass; 

kDeclareClassEx(kFs, kMsg, kMsgSet)

kFsFx(kStatus) xkMsg_ConstructFramework(kMsg* msg, kAlloc allocator); 

kFsFx(kStatus) kMsg_Init(kMsg msg, kType type, const kStamp* stamp, kObject data, kAlloc alloc);
kFsFx(kStatus) kMsg_VRelease(kMsg msg);
kFsFx(kStatus) kMsg_VDisposeItems(kMsg msg);
kFsFx(kStatus) kMsg_VClone(kMsg msg, kMsg other, kAlloc valueAlloc, kObject context); 
kFsFx(kBool) kMsg_VHasShared(kMsg msg);
kFsFx(kSize) kMsg_VSize(kMsg msg);
kFsFx(kAllocTrait) kMsg_VAllocTraits(kMsg msg);

kFsFx(kStatus) xkMsg_WriteDat5V3(kMsg msg, kSerializer serializer);
kFsFx(kStatus) xkMsg_ReadDat5V3(kMsg msg, kSerializer serializer);
kFsFx(kStatus) xkMsg_WriteDat6V0(kMsg msg, kSerializer serializer);
kFsFx(kStatus) xkMsg_ReadDat6V0(kMsg msg, kSerializer serializer);
kFsFx(kStatus) xkMsg_WriteDat6V1(kMsg msg, kSerializer serializer);
kFsFx(kStatus) xkMsg_ReadDat6V1(kMsg msg, kSerializer serializer);

kFsFx(kSize) kMsg_VCount(kMsg msg);
kFsFx(const kStamp*) kMsg_VStampAt(kMsg msg, kSize index);
kFsFx(kStatus) kMsg_VSetStampAt(kMsg msg, kSize index, const kStamp* stamp);
kFsFx(kStatus) kMsg_VDataAt(kMsg msg, kSize index, kArrayList* list);

#endif
