/** 
 * @file    kCrc32.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CRC32_X_H
#define K_FIRESYNC_CRC32_X_H

#include <kApi/Data/kArray1.h>

kDeclareValueEx(kFs, kCrc32Item, kValue)

typedef struct kCrc32Static
{
    kCrc32 normal;                //CRC object using kCRC32_POLYNOMIAL_NORMAL
} kCrc32Static; 

typedef struct kCrc32Class
{
    kObjectClass base; 
    kArray1 table;              //pre-computed table, based on selected polynomial -- kArray1<k32u>
} kCrc32Class;

typedef struct kCrc32VTable
{
    kObjectVTable base; 
} kCrc32VTable; 

kDeclareFullClassEx(kFs, kCrc32, kObject)

kFsFx(kStatus) xkCrc32_InitStatic();
kFsFx(kStatus) xkCrc32_ReleaseStatic();

kFsFx(kStatus) kCrc32_Init(kCrc32 crc, kType type, k32u polynomial, kAlloc alloc);
kFsFx(kStatus) kCrc32_VRelease(kCrc32 crc);

kFsFx(kStatus) kCrc32_GenerateTable(kCrc32 crc, k32u polynomial); 

#endif
