/** 
 * @file    kBinCSum4Alg.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_BIN_CSUM4_ALG_X_H
#define K_FIRESYNC_BIN_CSUM4_ALG_X_H

#include <kApi/Data/kArray1.h>

#define kBIN_CSUM4_ALG_DFEAULT_BACKGROUND_WIDTH         (32)


typedef struct kBinCSum4AlgClass
{
    kObjectClass base; 
    k32u binThreshold;                  //setting for binarize threshold
    k32u csumThreshold;                 //setting for csum threshold
    kSize backgroundWidth;              //setting for number of columns to sample for background noise
    kSize activePipeCount;              //setting for number of active PL pipes to simulate
    kArray1 adaptiveCSumThresholds;     //adaptive csum thresholds; one per active pipe -- kArray1<k32u>.
    kArray1 adaptiveBinThresholds;      //adaptive bin thresholds; one per active pipe -- kArray1<k32u>.
    kArray1 sums;                       //temp sums array
    kArray1 wsums;                      //temp weighted sums array
} kBinCSum4AlgClass; 

kDeclareClassEx(kFs, kBinCSum4Alg, kObject)
        
kFsFx(kStatus) kBinCSum4Alg_Init(kBinCSum4Alg alg, kType type, kAlloc alloc); 
kFsFx(kStatus) kBinCSum4Alg_VRelease(kBinCSum4Alg alg); 

kFsFx(kStatus) kBinCSum4Alg_Binarize(kBinCSum4Alg alg, kImage image, kArray2 bin); 
kFsFx(kStatus) kCSum4Alg_CalculateCSums(kBinCSum4Alg alg, kImage image, kArray1 result); 
kFsFx(kStatus) kBinCSum4Alg_UpdateThresholds(kBinCSum4Alg alg, kImage image); 

#endif
