/** 
 * @file    kSha256Hash.h
 * @brief   Declares the kSha256Hash class. 
 *
 * @internal
 * Copyright (C) 2021-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_API_SHA256_HASH_H
#define K_API_SHA256_HASH_H

#include <kFireSync/kFsDef.h>
#include <kApi/Crypto/kHash.h>

#include <kFireSync/Crypto/kSha256Hash.x.h>

/**
 * @class   kSha256Hash
 * @extends kHash
 * @ingroup kFireSync-Hash
 * @brief   Sha256 hash implementation.
 */
//typedef kHash kSha256Hash;   --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSha256Hash instance. 
 * 
 * @public                  @memberof kSha256Hash
 * @param   hash            Receives constructed sha256 object. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kSha256Hash_Construct(kSha256Hash* hash, kAlloc allocator);

#endif
