/** 
 * @file    kStorageItem.h
 * @brief   Declares the kStorageItem class. 
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_STORAGE_ITEM_H
#define K_FIRESYNC_STORAGE_ITEM_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kStorageItem
 * @extends kObject
 * @ingroup kFireSync-Client
 * @brief   Represents a storage item.
 */
//typedef kObject kStorageItem;        --forward-declared in kFsDef.x.h

/** 
 * Reports item size.
 *
 * Directories will have a reported size of 0.
 *
 * @public              @memberof kStorageItem
 * @param   storage     Storage object.  
 * @return              Size of the storage item.
 */
kFsFx(kSize) kStorageItem_Size(kStorageItem storage);

/** 
 * Reports item name.
 *
 * @public              @memberof kStorageItem
 * @param   storage     Storage object.  
 * @return              Name of the storage item.
 */
kFsFx(const kChar*) kStorageItem_Name(kStorageItem storage);

/** 
 * Reports item's entry type.
 *
 * @public              @memberof kStorageItem
 * @param   storage     Storage object.  
 * @return              Type of the storage item.
 */
kFsFx(kStorageEntry) kStorageItem_EntryType(kStorageItem storage);

#include <kFireSync/Client/kStorageItem.x.h>

#endif
