/** 
 * @file    kStorage.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_STORAGE_X_H
#define K_FIRESYNC_STORAGE_X_H

#include <kApi/Io/kPath.h>

typedef struct kStorageClass
{
    kObjectClass base; 

    kNode node;                     //Node object (owner). 

    kChar path0[kPATH_MAX];         //Used for absolute path generation in some functions.
    kChar path1[kPATH_MAX];         //Used for absolute path generation in some functions. 

} kStorageClass; 

kDeclareClassEx(kFs, kStorage, kObject)
        
kFsFx(kStatus) kStorage_Construct(kStorage* storage, kNode node, kAlloc allocator); 

kFsFx(kStatus) kStorage_Init(kStorage storage, kType type, kNode node, kAlloc alloc); 
kFsFx(kStatus) kStorage_VRelease(kStorage storage); 

kFsFx(kStatus) kStorage_Parse(kStorage storage, kXml xml, kXmlItem item); 
kFsFx(kStatus) kStorage_Format(kStorage storage, kXml xml, kXmlItem item); 

kFsFx(kStatus) kStorage_Verify(kStorage storage); 

kFsFx(kStatus) kStorage_ClearEx(kStorage storage, kNodeClearOption options); 

kFsFx(kStatus) kStorage_DeleteContent(kStorage storage); 
kFsFx(kStatus) kStorage_DeleteFiles(kStorage storage, const kChar* directory, const kChar** whiteList, kSize whiteListCount); 
kFsFx(kStatus) kStorage_DeleteDirectories(kStorage storage, const kChar* directory, const kChar** whiteList, kSize whiteListCount); 

kFsFx(kStatus) kStorage_ToRemotePath(kStorage storage, const kChar* path, kChar* remotePath, kSize capacity); 

kFsFx(kNode) kStorage_Node(kStorage storage);

#endif








