/** 
 * @file    kSerialOut.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_SERIAL_OUT_X_H
#define K_FIRESYNC_SERIAL_OUT_X_H

typedef struct kSerialOutClass
{
    kObjectClass base; 
    kNode node; 
    kSize index;

    kBool enabled; 
    kAnalogOutControl control; 
    k32u controlId; 

    kSerialOutMode mode;
    k32u bitRate;

} kSerialOutClass; 

kDeclareClassEx(kFs, kSerialOut, kObject)
        
kFsFx(kStatus) kSerialOut_Construct(kSerialOut* serial, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kSerialOut_Init(kSerialOut serial, kType type, kNode node, kSize index, kAlloc alloc); 
kFsFx(kStatus) kSerialOut_VRelease(kSerialOut serial); 

kFsFx(kStatus) kSerialOut_Parse(kSerialOut serial, kXml xml, kXmlItem item); 
kFsFx(kStatus) kSerialOut_Format(kSerialOut serial, kXml xml, kXmlItem item); 

kFsFx(kStatus) kSerialOut_VerificationLabel(kSerialOut serial, kChar* label, kSize capacity); 
kFsFx(kStatus) kSerialOut_Verify(kSerialOut serial); 

kFsFx(kStatus) kSerialOut_ClearEx(kSerialOut serial, kNodeClearOption options); 

#endif
