/** 
 * @file    kProjectorState.x.h
 *
 * @internal
 * Copyright (C) 2012-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROJECTOR_STATE_X_H
#define K_FIRESYNC_PROJECTOR_STATE_X_H

typedef struct kProjectorStateClass
{
    kObjectClass base; 

    kNode node; 
    kProjector projector; 
    kSize index; 

    k32u intensity;
    k64u exposure; 
    k64u gap; 
    kBool autoGapEnabled; 

    kArrayList nextStates;       //temp variable, used in validation -- kArrayList<kSize> 

} kProjectorStateClass; 

kDeclareClassEx(kFs, kProjectorState, kObject)
        
kFsFx(kStatus) kProjectorState_Construct(kProjectorState* state, kNode node, kProjector projector, kSize index, kAlloc allocator); 

kFsFx(kStatus) kProjectorState_Init(kProjectorState state, kType type, kNode node, kProjector projector, kSize index, kAlloc alloc); 
kFsFx(kStatus) kProjectorState_VRelease(kProjectorState state); 

kFsFx(kStatus) kProjectorState_Parse(kProjectorState state, kXml xml, kXmlItem item); 
kFsFx(kStatus) kProjectorState_Format(kProjectorState state, kXml xml, kXmlItem item); 

kFsFx(kStatus) kProjectorState_VerificationLabel(kProjectorState state, kChar* label, kSize capacity); 
kFsFx(kStatus) kProjectorState_Verify(kProjectorState state); 

kFsFx(k64u) kProjectorState_MinimumGap(kProjectorState state); 

kFsFx(kStatus) kProjectorState_SetIndex(kProjectorState state, kSize index); 

#endif
