/** 
 * @file    kProjector.x.h
 *
 * @internal
 * Copyright (C) 2012-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROJECTOR_X_H
#define K_FIRESYNC_PROJECTOR_X_H

typedef struct kProjectorClass
{
    kObjectClass base; 
    kNode node; 

    kProjectorModel model; 
    kProjectorInfo modelInfo;
    k64f pixelClockFrequency; 

    kSize index; 

    kBool enabled;  
    kBool isConnected;
    kProjectorControl control;    
    k32u controlId; 
    
    kBool dynamicFrameRate;
    kBool lightOutput;
    kBool autoShutdown;
    kSize frameCount;
    kSize bitDepth;
    kProjectorPatternMode patternMode;
    k32u palette[kPROJECTOR_PALETTE_CAPACITY];
    k32u maxIntensity;
    k32u minIntensity;

    kArrayList states;                    //kArrayList<kProjectorState>
    kArrayList extensions;                //kArrayList<kProjectorExt>
} kProjectorClass; 

kDeclareClassEx(kFs, kProjector, kObject)
        
kFsFx(kStatus) kProjector_Construct(kProjector* projector, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kProjector_Init(kProjector projector, kType type, kNode node, kSize index, kAlloc alloc); 
kFsFx(kStatus) kProjector_VRelease(kProjector projector); 

kFsFx(kStatus) kProjector_FormatVirtual(kProjector projector, kXml xml, kXmlItem item);

kFsFx(kStatus) kProjector_Parse(kProjector projector, kXml xml, kXmlItem item); 
kFsFx(kStatus) kProjector_ParseDevice(kProjector projector, kXml xml, kXmlItem item);
kFsFx(kStatus) kProjector_ParseStates(kProjector projector, kXml xml, kXmlItem item);
kFsFx(kStatus) kProjector_ParseExtensions(kProjector projector, kXml xml, kXmlItem item); 

kFsFx(kStatus) kProjector_Format(kProjector projector, kXml xml, kXmlItem item); 
kFsFx(kStatus) kProjector_FormatDevice(kProjector projector, kXml xml, kXmlItem item);
kFsFx(kStatus) kProjector_FormatStates(kProjector projector, kXml xml, kXmlItem item);
kFsFx(kStatus) kProjector_FormatExtensions(kProjector projector, kXml xml, kXmlItem item); 

kFsFx(kStatus) kProjector_VerificationLabel(kProjector projector, kChar* label, kSize capacity); 
kFsFx(kStatus) kProjector_Verify(kProjector projector); 

kFsFx(kStatus) kProjector_ClearEx(kProjector projector, kNodeClearOption options, kSize stateCount); 

kFsFx(kStatus) kProjector_FindSequenceExtension(kProjector projector, kProjectorExt* extension); 
kFsFx(kBool) kProjector_InterruptsEnabled(kProjector projector);

kFsFx(k32u) kProjector_MinIntensity(kProjector projector);
kFsFx(k32u) kProjector_MaxIntensity(kProjector projector);

kFsFx(kBool) kProjector_IsAutoIntensityEnabled(kProjector projector);

kFsFx(kProjectorInfo) kProjector_ModelInfo(kProjector projector); 
kFsFx(k64f) kProjector_PixelClockFrequency(kProjector projector); 

kFsFx(k64u) kProjector_MinimumEventPeriod(kProjector projector, kSize eventId); 
kFsFx(k64u) kProjector_MinPatternDuration(kProjector projector);

kFsFx(kNode) kProjector_Node(kProjector projector); 

#endif
