/** 
 * @file    kDigitalOut.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DIGITAL_OUT_X_H
#define K_FIRESYNC_DIGITAL_OUT_X_H

#define kDIGITAL_OUT_DEFAULT_DELAY          (0)
#define kDIGITAL_OUT_DEFAULT_EXPOSURE       (kDEFAULT_EXPOSURE_NS)
#define kDIGITAL_OUT_DEFAULT_GAP            (0)

typedef struct kDigitalOutClass
{
    kObjectClass base; 
    kNode node; 
    kSize index; 

    kBool enabled; 
    kDigitalOutControl control; 
    k32u controlId; 

    kBool polarity;

    k64u delay; 
    k64u exposure; 
    k64u gap; 

} kDigitalOutClass; 

kDeclareClassEx(kFs, kDigitalOut, kObject)
        
kFsFx(kStatus) kDigitalOut_Construct(kDigitalOut* digital, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kDigitalOut_Init(kDigitalOut digital, kType type, kNode node, kSize index, kAlloc alloc); 
kFsFx(kStatus) kDigitalOut_VRelease(kDigitalOut digital); 

kFsFx(kStatus) kDigitalOut_Parse(kDigitalOut digital, kXml xml, kXmlItem item); 
kFsFx(kStatus) kDigitalOut_Format(kDigitalOut digital, kXml xml, kXmlItem item); 

kFsFx(kStatus) kDigitalOut_VerificationLabel(kDigitalOut digital, kChar* label, kSize capacity); 
kFsFx(kStatus) kDigitalOut_Verify(kDigitalOut digital); 

kFsFx(kStatus) kDigitalOut_ClearEx(kDigitalOut digital, kNodeClearOption options);

kFsFx(k64u) kDigitalOut_MinimumEventPeriod(kDigitalOut digital, kSize eventId); 

#endif
