/** 
 * @file    kCameraState.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_STATE_X_H
#define K_FIRESYNC_CAMERA_STATE_X_H

typedef struct kCameraStateClass
{
    kObjectClass base; 

    kNode node; 
    kCamera camera; 
    kSize index; 

    k32u left; 
    k32u top; 
    k32u width; 
    k32u height; 
    k32u xSub; 
    kCameraSubsampling xSubMode; 
    k32u ySub; 
    kCameraSubsampling ySubMode; 
    kBool invertX; 
    kBool invertY; 
    kBool autoBlackEnabled; 
    k32s blackLevel;
    k32u gain[kCAMERA_GAIN_CAPACITY]; 
    kCameraExposure exposureMode; 
    kSize maxBatchSize; 
    k64u delay; 
    k64u exposure; 
    k64u gap; 
    kBool autoGapEnabled; 
    kAlgInfo algorithmConfig; 
    k32u ramImageCount; 

    kArrayList kneePoints;
    kArrayList nextStates;       //temp variable, used in validation -- kArrayList<kSize> 

} kCameraStateClass; 

kDeclareClassEx(kFs, kCameraState, kObject)
        
kFsFx(kStatus) kCameraState_Construct(kCameraState* state, kNode node, kCamera camera, kSize index, kAlloc allocator); 

kFsFx(kStatus) kCameraState_Init(kCameraState state, kType type, kNode node, kCamera camera, kSize index, kAlloc alloc); 
kFsFx(kStatus) kCameraState_VRelease(kCameraState state); 

kFsFx(kStatus) kCameraState_Parse(kCameraState state, kXml xml, kXmlItem item); 
kFsFx(kStatus) kCameraState_ParseAlgorithm(kCameraState state, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraState_Format(kCameraState state, kXml xml, kXmlItem item); 
kFsFx(kStatus) kCameraState_FormatAlgorithm(kCameraState state, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraState_VerificationLabel(kCameraState state, kChar* label, kSize capacity); 
kFsFx(kStatus) kCameraState_Verify(kCameraState state); 

kFsFx(k64u) kCameraState_MinimumGap(kCameraState state); 

kFsFx(kStatus) kCameraState_NextStates(kCameraState state, kArrayList states); 

kFsFx(k32u) kCameraState_PlPipeCount(kCameraState state);

kFsFx(kStatus) kCameraState_FindExtension(kCameraState state, kType type, kCameraExt* extension);

kFsFx(kBool) kCameraState_IsPlSequencingAllowed(kCameraState state, kCameraState next);

//reported in FS NS
kFsFx(k64u) kCameraState_ReadoutTime(kCameraState state);
kFsFx(k64u) kCameraState_MinInterExposureGap(kCameraState state);
kFsFx(k64u) kCameraState_MinInterReadoutGap(kCameraState state);
kFsFx(k64u) kCameraState_MinExposure(kCameraState state);
kFsFx(k64u) kCameraState_MaxExposure(kCameraState state);
kFsFx(kStatus) kCameraState_InitInfoTimingParams(kCameraState state, kCameraInfoParams* params);

kFsFx(k64u) kCameraState_PlProcessingTime(kCameraState state);
kFsFx(k64u) kCameraState_PlPostProcessingTime(kCameraState state);
kFsFx(k64u) kCameraState_MinIsrGap(kCameraState state);

kFsFx(kStatus) kCameraState_SetIndex(kCameraState state, kSize index); 

kFsFx(kNode) kCameraState_Node(kCameraState state); 

kFsFx(kSize) kCameraState_ActivePlPipeCount(kCameraState state); 

kFsFx(kSize) kCameraState_VideoFrameSize(kCameraState state);
kFsFx(kSize) kCameraState_AlgorithmFrameSize(kCameraState state);

kFsFx(kBool) kCameraState_IsRoiChangedAlgEnabled(kCameraState previous, kCameraState current);

//[Deprecated] Replace with kCameraState_LeadInNs
#define kCameraState_ExposureOverheadNs kCameraState_LeadInNs

//[Deprecated] Replace with kCameraState_LeadOutNs
#define kCameraState_ExposureBlankingNs kCameraState_LeadOutNs

#endif
