/** 
 * @file    kAnalogOut.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ANALOG_OUT_X_H
#define K_FIRESYNC_ANALOG_OUT_X_H

#define kANALOG_OUT_MAX_VALUE_MCP4725               (0xFFF)         //12-bit A/D for MCP4725
#define kANALOG_OUT_MAX_VALUE_AD5623                (0xB00)         //12-bit A/D for AD5623 mapped for 22mA
#define kANALOG_OUT_MIN_NOMINAL_CURRENT             (0.0)           //nominal milliamps
#define kANALOG_OUT_MAX_NOMINAL_CURRENT             (22.0)          //nominal milliamps

typedef struct kAnalogOutClass
{
    kObjectClass base; 
    kNode node; 
    kSize index; 

    kBool enabled; 
    kAnalogOutControl control; 
    k32u controlId; 
    k64f calA0; 
    k64f calA1; 

    kAnalogOutModel analogOutModel;
    k32u maxValue;

    k64f minCurrent;        //minimum valid output current value (mA)
    k64f maxCurrent;        //maximum valid output current value (mA)
    kBool isCalibrated;     //has analog output calibration been provided?

} kAnalogOutClass; 

kDeclareClassEx(kFs, kAnalogOut, kObject)
        
kFsFx(kStatus) kAnalogOut_Construct(kAnalogOut* analog, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kAnalogOut_Init(kAnalogOut analog, kType type, kNode node, kSize index, kAlloc alloc); 
kFsFx(kStatus) kAnalogOut_VRelease(kAnalogOut analog); 

kFsFx(kStatus) kAnalogOut_Parse(kAnalogOut analog, kXml xml, kXmlItem item); 

kFsFx(kStatus) kAnalogOut_Format(kAnalogOut analog, kXml xml, kXmlItem item); 

kFsFx(kStatus) kAnalogOut_VerificationLabel(kAnalogOut analog, kChar* label, kSize capacity); 
kFsFx(kStatus) kAnalogOut_Verify(kAnalogOut analog); 

kFsFx(kStatus) kAnalogOut_ClearEx(kAnalogOut analog, kNodeClearOption options); 

kFsFx(k64f) kAnalogOut_MinNominalCurrent(kAnalogOut analog); 
kFsFx(k64f) kAnalogOut_MaxNominalCurrent(kAnalogOut analog); 
kFsFx(k64f) kAnalogOut_CalibratedCurrentToNominalCurrent(kAnalogOut analog, k64f calibrated); 
kFsFx(k64f) kAnalogOut_NominalCurrentToCalibratedCurrent(kAnalogOut analog, k64f nominal); 

kFsFx(k32u) kAnalogOut_CalibratedCurrentToValue(kAnalogOut analog, k64f calibrated); 

/* 
 * The following deprecated functions need to been retained until FSS-1346 is completed. 
 * When that ticket is completed, these declarations (and their helper function definitions) 
 * should be removed.
 */ 

#if defined (K_NO_DEPRECATION)

//Deprecated: convert to kAnalogOut_SetCalibration.
#define kAnalogOut_SetCalA0 kAnalogOut_SetCalA0Deprecated
kFsFx(kStatus) kAnalogOut_SetCalA0Deprecated(kAnalogOut analog, k64f a0);
kDeprecate(kAnalogOut_SetCalA0)

//Deprecated: no replacement.
#define kAnalogOut_CalA0 kAnalogOut_CalA0Deprecated
kFsFx(k64f) kAnalogOut_CalA0Deprecated(kAnalogOut analog);
kDeprecate(kAnalogOut_CalA0)

//Deprecated: convert to kAnalogOut_SetCalibration
#define kAnalogOut_SetCalA1 kAnalogOut_SetCalA1Deprecated
kFsFx(kStatus) kAnalogOut_SetCalA1Deprecated(kAnalogOut analog, k64f a1);
kDeprecate(kAnalogOut_SetCalA1)

//Deprecated: no replacement.
#define kAnalogOut_CalA1 kAnalogOut_CalA1Deprecated
kFsFx(k64f) kAnalogOut_CalA1Deprecated(kAnalogOut analog);
kDeprecate(kAnalogOut_CalA1)

//Deprecated: convert to kAnalogOut_OutputInfo or kAnalogOut_NominalOutputInfo
#define kAnalogOut_MaxValue kAnalogOut_MaxValueDeprecated
kFsFx(k32u) kAnalogOut_MaxValueDeprecated(kAnalogOut analog);
kDeprecate(kAnalogOut_MaxValue)

//Deprecated: convert to kAnalogOut_OutputInfo or kAnalogOut_NominalOutputInfo
#define kAnalogOut_MinCurrent kAnalogOut_MinCurrentDeprecated
kFsFx(k64f) kAnalogOut_MinCurrentDeprecated(kAnalogOut analog);
kDeprecate(kAnalogOut_MinCurrent)

//Deprecated: convert to kAnalogOut_OutputInfo or kAnalogOut_NominalOutputInfo
#define kAnalogOut_MaxCurrent kAnalogOut_MaxCurrentDeprecated
kFsFx(k64f) kAnalogOut_MaxCurrentDeprecated(kAnalogOut analog);
kDeprecate(kAnalogOut_MaxCurrent)

//Deprecated: convert to kAnalogOut_EnqueueOutput
#define kAnalogOut_EnqueueValue kAnalogOut_EnqueueValueDeprecated
kFsFx(kStatus) kAnalogOut_EnqueueValueDeprecated(kAnalogOut analog, k32u value);
kDeprecate(kAnalogOut_EnqueueValue)

//Deprecated: convert to kAnalogOut_EnqueueOutput
#define kAnalogOut_EnqueueCurrent kAnalogOut_EnqueueCurrentDeprecated
kFsFx(kStatus) kAnalogOut_EnqueueCurrentDeprecated(kAnalogOut analog, k64f current);
kDeprecate(kAnalogOut_EnqueueCurrent)

//Deprecated: convert to kAnalogOut_EnqueueOutput and kEventManager_Schedule
#define kAnalogOut_ScheduleState kAnalogOut_ScheduleStateDeprecated
kFsFx(kStatus) kAnalogOut_ScheduleStateDeprecated(kAnalogOut analog, k64s target, k32u value);
kDeprecate(kAnalogOut_ScheduleState)

//Deprecated: convert to kAnalogOut_EnqueueOutput
#define kAnalogOut_EnqueueStates kAnalogOut_EnqueueStatesDeprecated
kFsFx(kStatus) kAnalogOut_EnqueueStatesDeprecated(kAnalogOut analog, k32u* values, kSize count);
kDeprecate(kAnalogOut_EnqueueStates)

//Deprecated: convert to kAnalogOut_EnqueueOutput
#define kAnalogOut_SetState kAnalogOut_SetStateDeprecated
kFsFx(kStatus) kAnalogOut_SetStateDeprecated(kAnalogOut analog, k32u value);
kDeprecate(kAnalogOut_SetState)

//Deprecated: convert to kAnalogOut_EnqueueOutput
#define kAnalogOut_EnqueueState kAnalogOut_EnqueueStateDeprecated
kFsFx(kStatus) kAnalogOut_EnqueueStateDeprecated(kAnalogOut analog, k32u value);
kDeprecate(kAnalogOut_EnqueueState)

#endif

#endif
