/** 
 * @file    kLp01Info.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LP01_INFO_X_H
#define K_FIRESYNC_LP01_INFO_X_H

#define kLP01_WIDTH                             (960)
#define kLP01_HEIGHT                            (540)

#define kLP01_MIN_PATTERN_COUNT                 (1)                     ///< Minimum pattern count.
#define kLP01_MAX_PATTERN_COUNT                 (24)                    ///< Maximum pattern count.
#define kLP01_MAX_FRAME_REPEAT_COUNT            (255)                   ///< Maximum frame repeat count.

#define kLP01_MIN_BIT_DEPTH                     (8)                     ///< Minimum pattern bit depth.
#define kLP01_MAX_BIT_DEPTH                     (8)                     ///< Maximum pattern bit depth.
#define kLP01_DEFAULT_BIT_DEPTH                 (8)                     ///< Default pattern bit depth.

#define kLP01_MIN_INTENSITY                     (0)                     ///< Minimum intensity.
#define kLP01_MAX_INTENSITY                     (160)                   ///< Maximum intensity.
#define kLP01_DEFAULT_INTENSITY                 (90)                    ///< Default intensity.

#define kLP01_MIN_PALETTE_COLOR                 (0)                     ///< Minimum palette color.
#define kLP01_MAX_PALETTE_COLOR                 (255)                   ///< Maximum palette color.

#define kLP01_HSYNC_WIDTH                       (0x10)                  ///< HSync width.
#define kLP01_HSYNC_BACK_PORCHE                 (0x0A)                  ///< HSync back porche.
#define kLP01_HSYNC_FRONT_PORCHE                (0x0E)                  ///< HSync front porche.
#define kLP01_VSYNC_WIDTH                       (0x0A)                  ///< VSync width.
#define kLP01_VSYNC_BACK_PORCHE                 (0x05)                  ///< VSync back porche.
#define kLP01_VSYNC_FRONT_PORCHE                (0x07)                  ///< VSync front porche.

#define kLP01_COLOR_WEIGHT_COUNT                (3)                     ///< The number of color weights. 
#define kLP01_COLOR_WEIGHT_SUM                  (256)                   ///< The sum of all the color weights.
#define kLP01_MIN_COLOR_WEIGHT                  (0x1F)                  ///< Minimum usable color weight.
#define kLP01_MAX_COLOR_WEIGHT                  (0xF0)                  ///< Maximum usable color weight.
#define kLP01_MIN_LED_TIME                      (390000)                ///< LED time for minimum color weight (real ns).
#define kLP01_MAX_LED_TIME                      (3708000)               ///< LED time for maximum color weight (real ns).
#define kLP01_INFO_DEFAULT_EXPOSURE             (2000000)               ///< LP01 default exposure.

#define kLP01_INFO_PILOT_RUN_EXPOSURE           (kLP01_MAX_LED_TIME)    ///< LP01 pilot run exposure
#define kLP01_INFO_PILOT_RUN_PERIOD             (8000000)               ///< LP01 pilot run period

#define kLP01_ELIMINATE_FLICKER_FACTOR          (5000)                  ///< Factor to eliminate flicker for one pattern projecting (real ns).

#define kLP01_SEQUENCING_OVERHEAD               (1024000)               ///< Sequencing overhead (fs ns).

typedef struct kLp01InfoClass
{
    kProjectorInfoClass base; 

    k64u minColorWeight;
    k64u maxColorWeight;
    k64u minLedTime;
    k64u maxLedTime;
} kLp01InfoClass;

kDeclareClassEx(kFs, kLp01Info, kProjectorInfo)
        
kFsFx(kStatus) kLp01Info_Init(kLp01Info info, kType type, k64f pixelClockFrequency, kAlloc alloc);
kFsFx(kStatus) kLp01Info_VRelease(kLp01Info info);

kFsFx(k64u) kLp01Info_VImageTime(kLp01Info info, kSize bitDepth, k64u exposure, kBool dynFrameRate);
kFsFx(k64u) kLp01Info_VFrameTime(kLp01Info info, kSize bitDepth, k64u exposure, kBool dynFrameRate);
kFsFx(kStatus) kLp01Info_VCalculateExposure(kLp01Info info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kProjectorTiming* timing);
kFsFx(k64u) kLp01Info_VSequenceDuration(kLp01Info info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kSize patternCount, kBool sequenceEnabled);
kFsFx(k64u) kLp01Info_VMinimumGap(kLp01Info info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kSize patternCount, kBool sequenceEnabled, k64u cameraPlProcessingTime);
kFsFx(k64u) kLp01Info_VNominateCameraExposure(kLp01Info info, kSize bitDepth, k64u stateExposure, k64u cameraDuration, kBool dynFrameRate, k64u desiredExposure);
kFsFx(kProjectorExtension) kLp01Info_VExtensionTypes(kLp01Info info);

#endif
