/** 
 * @file    kDp03Info.h
 * @brief   Declares the kDp03Info class and related types. 
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DP03_INFO_H
#define K_FIRESYNC_DP03_INFO_H

#include <kFireSync/Client/Projector/kProjectorInfo.h>

/**
 * @internal
 * @class   kDp03Info
 * @extends kProjectorInfo
 * @ingroup kFireSync-Client-Projector
 * @brief   Represents information about the DP03 projector model. 
 */
//typedef kProjectorInfo kDp03Info;             --forward-declared in kFsDef.x.h

/** 
 * Constructs a kDp03Info object.
 *
 * @public              @memberof kDp03Info
 * @param   info        Destination for the constructed object handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kDp03Info_Construct(kDp03Info* info, k64f pixelClockFrequency, kAlloc allocator);

#include <kFireSync/Client/Projector/kDp03Info.x.h>

#endif
