/** 
 * @file    kProjectorAutoInt.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROJECTOR_AUTO_INT_X_H
#define K_FIRESYNC_PROJECTOR_AUTO_INT_X_H

#define kPROJECTOR_AUTO_INT_MAX_FRAME_REPEAT_COUNT      (8)
#define kPROJECTOR_AUTO_INT_MIN_SLOPE_VALUE             (0.001)

#define kPROJECTOR_AUTO_INT_DEFAULT_MIN_INTENSITY       (0)
#define kPROJECTOR_AUTO_INT_DEFAULT_MAX_INTENSITY       (255)
#define kPROJECTOR_AUTO_INT_DEFAULT_SLOPE               (48)

typedef struct kProjectorAutoIntClass
{
    kProjectorExtClass base;
    k32u minIntensity;
    k32u maxIntensity;
    kArrayList slopes;

} kProjectorAutoIntClass;

kDeclareClassEx(kFs, kProjectorAutoInt, kProjectorExt)

kFsFx(kStatus) xkProjectorAutoInt_Construct(kProjectorAutoInt* extension, kAlloc allocator);

kFsFx(kStatus) kProjectorAutoInt_Init(kProjectorAutoInt extension, kType type, kAlloc alloc);
kFsFx(kStatus) kProjectorAutoInt_VRelease(kProjectorAutoInt extension);

kFsFx(kStatus) kProjectorAutoInt_VClone(kProjectorAutoInt extension, kProjectorAutoInt other, kAlloc valueAlloc, kObject context);

kFsFx(kStatus) kProjectorAutoInt_VRead(kProjectorAutoInt extension, kXml xml, kXmlItem item);
kFsFx(kStatus) kProjectorAutoInt_VWrite(kProjectorAutoInt extension, kXml xml, kXmlItem item);

kFsFx(kStatus) kProjectorAutoInt_VerificationLabel(kProjectorAutoInt extension, kChar* label, kSize capacity);
kFsFx(kStatus) kProjectorAutoInt_VVerify(kProjectorAutoInt extension);

#endif
