/** 
 * @file    kNode6Client.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_NODE_6_CLIENT_X_H
#define K_FIRESYNC_NODE_6_CLIENT_X_H

typedef struct kNode6ClientClass
{
    kObjectClass base; 
    kIpAddress serverAddress;

    k32u controlPort;                       //Remote control port.
    k32u healthPort;                        //Remote health port.
    k32u dataPort;                          //Remote data port.
    kCallback errorHandler;                 //Called on control communication error. 
    kCallback cancelQuery;                  //I/O cancellation callback (control). 
    kAlloc messageAlloc;                    //Allocator for health/data messages. 

    kSize dataBufferSize;                   //Data channel socket read buffer size.
    kSize hasDataConfigChanges;             //Has data channel configuration changed size last open?

    kControl6Client control;                //Control connection.
    kHealth6Client health;                  //Health connection.

    kCallback dataHandler;                  //Data receive callback. 
    kBool isOpeningData;                    //Used to communicate state between BeginOpenData/EndOpenData
    kData6Client data;                      //Active data connection.
    kList closingData;                      //Data connections that are no longer needed, but not yet closed. 

} kNode6ClientClass; 

kDeclareClassEx(kFs, kNode6Client, kObject)
        
kFsFx(kStatus) kNode6Client_Init(kNode6Client client, kType type, kIpAddress address, kAlloc alloc); 
kFsFx(kStatus) kNode6Client_VRelease(kNode6Client client); 

kFsFx(kStatus) kNode6Client_FinalizeData(kNode6Client client);

#endif
