/** 
 * @file    kDiscovery5Client.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DISCOVERY_5_CLIENT_X_H
#define K_FIRESYNC_DISCOVERY_5_CLIENT_X_H

#define kDISCOVERY_5_CLIENT_CLIENT_READ_BUFFER                      (1536)
#define kDISCOVERY_5_CLIENT_CLIENT_WRITE_BUFFER                     (1536)

#define kDISCOVERY_5_CLIENT_QUIT_QUERY_PERIOD                       (100000)
#define kDISCOVERY_5_CLIENT_QUIT_SEND_TIMEOUT                       (100000)
#define kDISCOVERY_5_CLIENT_DEFAULT_ENUM_PERIOD                     (1000000)

#define kDISCOVERY_5_CLIENT_LEGACY_RESCUE_PERIOD                    (100000)            // Legacy rescue period
#define kDISCOVERY_5_CLIENT_LEGACY_RESCUE_PORT                      (4444)              // Legacy rescue port
#define kDISCOVERY_5_CLIENT_LEGACY_RESCUE_MESSAGE                   "LMI_RESCUE_REQ"    // Legacy rescue message

#define kDISCOVERY_5_CLIENT_CLIENT_PORT                             (2002)      // kETHERNET_CONTROL_APPLICATION_DISCOVERY_PORT

#define kDISCOVERY_5_CLIENT_NODE_INFO_COUNT                         (50)        // kEthernetDiscDevInfo devices[50]
#define kDISCOVERY_5_CLIENT_MESSAGE_TYPE_ANNOUNCEMENT               (0)         // kETHERNET_DISC_ANNOUNCEMENT
#define kDISCOVERY_5_CLIENT_MESSAGE_TYPE_UPDATE                     (1)         // kETHERNET_DISC_UPDATE

#define kDISCOVERY_5_CLIENT_DEVICE_ID_SERIAL_MASK                   (0x00FFFFFF)// kDEVICEID_SERIAL_MASK
#define kDISCOVERY_5_CLIENT_DEVICE_ID_SERIAL_SHIFT                  (0)         // kDEVICEID_SERIAL_SHIFT

#define kDISCOVERY_5_CLIENT_DEVICE_ID_LOCATION_MASK                 (0x1)       // kDEVICEID_LOCATION_MASK
#define kDISCOVERY_5_CLIENT_DEVICE_ID_LOCATION_SHIFT                (24)        // kDEVICEID_LOCATION_SHIFT

#define kDISCOVERY_5_CLIENT_DEVICE_ID_LOCATION_REMOTE               (0x0)       // kDEVICEID_LOCATION_REMOTE
#define kDISCOVERY_5_CLIENT_DEVICE_ID_LOCATION_LOCAL                (0x1)       // kDEVICEID_LOCATION_LOCAL

#define kDISCOVERY_5_CLIENT_DEVICE_ID_TYPE_MASK                     (0xF)       // kDEVICEID_TYPE_MASK
#define kDISCOVERY_5_CLIENT_DEVICE_ID_TYPE_SHIFT                    (28)        // kDEVICEID_TYPE_SHIFT

#define kDISCOVERY_5_CLIENT_NODE_TYPE_SENSOR                        (0x05)      // kDEVICEID_TYPE_SENSOR
#define kDISCOVERY_5_CLIENT_NODE_TYPE_STATION                       (0x06)      // kDEVICEID_TYPE_STATION
#define kDISCOVERY_5_CLIENT_NODE_TYPE_MASTER                        (0x08)      // kDEVICEID_TYPE_MASTER

typedef struct kDiscovery5ClientClass
{
    kObjectClass base; 

    kThread thread;                 //Background thread to receive messages and dispatch updates.
    k64u enumPeriod;                //Enumeration period (us). 
    kDiscoveryEnumFx enumFx;        //Enumeration callback. 
    kPointer enumRx;                //Enumeration receiver. 
    kUdpClient receiver;            //Receives broadcasts. 
    kSerializer reader;             //Deserializes received messages. 
    kSemaphore firstSem;            //Set when first read is completed. 
    kArrayList discovered;          //Nodes discovered since last update -- kArrayList<kDiscoveryInfo>.
    kArrayList nodeInfo;            //Node information as per received message -- kArrayList<kDiscoveryInfo>.
    kAtomic32s shouldQuit;          //Indicates when thread should quit. 

    kPeriodic rescueTimer;          //Periodic background thread to send rescue requests. 
    k64u rescuePeriod;              //Rescue broadcast period (us). 
    kArrayList rescueClients;       //Rescue senders -- kArrayList<kUdpClient>. 
    kArrayList rescueWriters;       //Rescue serializers -- kArrayList<kSerializer>

    kArrayList adapterList;         //List of adapter ids to use for discovery -- kArrayList<kSize>

} kDiscovery5ClientClass; 

kDeclareClassEx(kFs, kDiscovery5Client, kObject)
        
kFsFx(kStatus) kDiscovery6Client_DefaultConstruct(kDiscovery6Client* client, kType type, kSystem system, kAlloc alloc); 

kFsFx(kStatus) kDiscovery5Client_Init(kDiscovery5Client client, kType type, kAlloc alloc); 
kFsFx(kStatus) kDiscovery5Client_VRelease(kDiscovery5Client client); 

kFsFx(kBool) kDiscovery5Client_CanSetAddress(kDiscovery5Client client); 
kFsFx(kStatus) kDiscovery5Client_SetAddress(kDiscovery5Client client, k32u id, kSize localAdapterId, kSize nodeInterfaceIndex, const kIpConfig* ipConfig);

kFsFx(kStatus) kDiscovery5Client_SetEnumHandler(kDiscovery5Client client, kDiscoveryEnumFx function, kPointer receiver); 

kFsFx(kStatus) kDiscovery5Client_StartEnum(kDiscovery5Client client); 
kFsFx(kStatus) kDiscovery5Client_WaitFirst(kDiscovery5Client client); 
kFsFx(kStatus) kDiscovery5Client_StopEnum(kDiscovery5Client client); 

kFsFx(kStatus) kDiscovery5Client_ConstructNodeProvider(kDiscovery5Client client, const kDiscoveryInfo* info, kNodeProvider* nodeProvider, kAlloc allocator); 

kFsFx(kStatus) kDiscovery5Client_ThreadEntry(kDiscovery5Client client); 
kFsFx(kStatus) kDiscovery5Client_ReceiveUpdate(kDiscovery5Client client, k64u timeout); 
kFsFx(kStatus) kDiscovery5Client_ReadUpdate(kDiscovery5Client client); 

kFsFx(kStatus) kDiscovery5Client_StartRescueRequests(kDiscovery5Client client); 
kFsFx(kStatus) kDiscovery5Client_StopRescueRequests(kDiscovery5Client client); 
kFsFx(kStatus) kDiscovery5Client_OnRescueTimer(kDiscovery5Client client, kPeriodic timer); 

kFsFx(kStatus) kDiscovery5Client_AddAdapter(kDiscovery5Client client, const kChar* name);
kFsFx(kBool) kDiscovery5Client_ShouldUseAdapter(kDiscovery5Client client, kSize adapterId);

#endif
