/** 
 * @file    kData6Client.h
 * @brief   Declares the kData6Client class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DATA_6_CLIENT_H
#define K_FIRESYNC_DATA_6_CLIENT_H

#include <kFireSync/kNodeDef.h>

/**
 * @internal
 * @class   kData6Client
 * @extends kObject
 * @ingroup kFireSync-Client-Network
 * @brief   Implements an FDSP-6 client. 
 */
//typedef kObject kData6Client;            --forward-declared in kFsDef.x.h

/** 
 * Constructs a kData6Client object.
 *
 * @public              @memberof kData6Client
 * @return              Operation status. 
 */
kFsFx(kStatus) kData6Client_Construct(kData6Client* client, kAlloc allocator); 

kFsFx(kStatus) kData6Client_SetMessageAlloc(kData6Client client, kAlloc alloc);

kFsFx(kStatus) kData6Client_SetBufferSize(kData6Client client, kSize size);

kFsFx(kStatus) kData6Client_SetReceiveHandler(kData6Client client, kCallbackFx function, kPointer receiver);

kFsFx(kBool) kData6Client_SourcePortsEqual(kData6Client client, const k16u* outputPorts, kSize count); 

kFsFx(kStatus) kData6Client_SetSourcePorts(kData6Client client, const k16u* outputPorts, kSize count); 

kFsFx(kStatus) kData6Client_BeginOpen(kData6Client client, kIpAddress ipAddress, k32u ipPort); 
kFsFx(kStatus) kData6Client_EndOpen(kData6Client client); 

kFsFx(kStatus) kData6Client_EndDataSession(kData6Client client);

kFsFx(kStatus) kData6Client_Close(kData6Client client, k64u timeout);

#include <kFireSync/Client/Network/kData6Client.x.h>

#endif
