/** 
 * @file    kLightExt.h
 * @brief   Declares the kLightExt type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LIGHT_EXT_H
#define K_FIRESYNC_LIGHT_EXT_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kLightExt
 * @extends kObject
 * @ingroup kFireSync-Client-Light-Extensions
 * @brief   Abstract base class for light control extension parameters. 
 * 
 * Note to implementers: kLightExt and its derived types are used in both client and server/hardware contexts. 
 * This approach reduces code duplication, but imposes some complexity/limitations on the implementation. 
 * Because these types can be used separately from the kFireSync/Client object hierarchy, it cannot be assumed 
 * that a sequence object has a reference to its client-side parent (kLight). 
 */
//typedef kObject kLightExt;             --forward-declared in kFsDef.x.h

/** 
 * Enables or disables the extension. 
 *
 * @public              @memberof kLightExt
 * @param   extension   Extneion object.  
 * @param   enable      Specifies whether to enable or disable the extension.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kLightExt_Enable(kLightExt extension, kBool enable);

/** 
 * Reports whether the extension is currently enabled. 
 *
 * @public              @memberof kLightExt
 * @param   extension   Extneion object.  
 * @return              Returns whether the extension is currently enabled. 
 */
kFsFx(kBool) kLightExt_IsEnabled(kLightExt extension);

#include <kFireSync/Client/Light/Extensions/kLightExt.x.h>

#endif
