/**
 * @file    kLc500xInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC500X_INFO_X_H
#define K_FIRESYNC_LC500X_INFO_X_H

// NOTE: LC5000 in 4 or 8 channels will not support algorithm as per Julio.
#define kLC500X_MIN_WIDTH                           (32)                ///< Imager minimum width (pixels).
#define kLC500X_MAX_WIDTH                           (2592)              ///< Imager maximum width (pixels).
#define kLC500X_WIDTH_GRANULARITY                   (16)                ///< Imager width granularity based on kernel size (pixels).
#define kLC500X_MIN_HEIGHT                          (2)                 ///< Imager minimum height (pixels).
#define kLC500X_MAX_HEIGHT                          (2048)              ///< Imager maximum height (pixels).
#define kLC500X_RLUT_WIDTH                          (2048)              ///< Range LUT width (TODO: FSS-360, FSS-384).
#define kLC500X_RLUT_HEIGHT                         (2048)              ///< Range LUT height (TODO: FSS-360, FSS-384).
#define kLC500X_HEIGHT_GRANULARITY                  (2)                 ///< Imager height granularity (pixels).
#define kLC500X_LEFT_GRANULARITY                    (16)                ///< Window x granularity (pixels). 
#define kLC500X_TOP_GRANULARITY                     (2)                 ///< Window y granularity (pixels). 
#define kLC500X_PRE_EXPOSURE                             (538)               ///< Lead in (pixel periods).
#define kLC500X_POST_EXPOSURE                            (6654)              ///< Lead out (pixel periods).
#define kLC500X_MIN_EXPOSURE                        (7021)              ///< Minimum exposure (pixel periods).
#define kLC500X_MAX_EXPOSURE                        (1000000000)        ///< Maximum exposure (ns).
#define kLC5000_MAX_IMAGER_X_SUB                    (2)                 ///< Maximum x-subsampling supported by imager.
#define kLC5001_MAX_IMAGER_X_SUB                    (1)                 ///< Maximum x-subsampling supported by imager.
#define kLC500X_MAX_IMAGER_Y_SUB                    (2)                 ///< Maximum y-subsampling supported by imager.
#define kLC500X_IMAGER_X_SUB_OPTIONS                (3)                 ///< X-subsampling options supported by imager.
#define kLC500X_IMAGER_Y_SUB_OPTIONS                (3)                 ///< Y-subsampling options supported by imager.
#define kLC500X_DIGITAL_GAIN_GRANULARITY            (0.0078125)         ///< Digital gain step granularity.
#define kLC500X_DIGITAL_GAIN_MAX_STEP               (3968)              ///< Maximum digital gain step.
#define kLC500X_MIN_BLACK_LEVEL                     (0)                 ///< Minimum black level value.
#define kLC500X_MAX_BLACK_LEVEL                     (0xFF)              ///< Maximum black level value.
#define kLC500X_MIN_KNEE_COUNT                      (0)                 ///< Multi-Slope minimum knee count
#define kLC500X_MAX_KNEE_COUNT                      (2)                 ///< Multi-Slope minimum knee count
#define kLC500X_KNEE_COUNT_GRANULARITY              (1)                 ///< Multi-Slope knee count granularity

#define kLC500X_MIN_INTER_READOUT_GAP               (0)                 ///< Minimum time between end of readout and start of next readout (ns).  

//TODO: needs to be verified.
#define kLC500X_DEFAULT_CENTROID_STEP_8K            (32)                ///< Range LUT Default CG step (8K entries)
#define kLC500X_DEFAULT_CENTROID_STEP_16K           (16)                ///< Range LUT Default CG step (16K entries)
#define kLC500X_DEFAULT_VALID_STEP                  (8)                 ///< Range LUT Default valid step
#define kLC500X_DEFAULT_SLICE_STEP                  (32)                ///< Range LUT Default slice step

/*
 * register set constants -- refer to imager driver, datasheets, appnotes and characterization document.
 */

#define kLC500X_ROT_IMG_BL_SINGLE_SLOPE             (272)               ///< Single slope ROT length (pixel periods: ~68*4)
#define kLC500X_XSM_DELAY_SINGLE_SLOPE              (0)                 ///< Single slope XSM delay (pixel periods: 0*4)
#define kLC500X_ROT_IMG_BL_MULTI_SLOPE              (392)               ///< Multi slope ROT length (pixel periods: ~98*4)
#define kLC500X_XSM_DELAY_MULTI_SLOPE               (320)               ///< Multi slope XSM delay (pixel periods: 80*4)

#define kLC500X_FOT_SINGLE_SLOPE                    (11000)             ///< Single slope FOT length (pixel periods)
#define kLC500X_FOT_MULTI_SLOPE                     (20352)             ///< Multi slope FOT length (pixel periods)

#define kLC500X_MIN_INTER_KNEE_GAP_0                (0)                 ///< Multi slope minimum inter knee gap 0
#define kLC500X_MIN_INTER_KNEE_GAP_1                (12544)             ///< Multi slope minimum inter knee gap 1 (FOT_DS*4: 3136*4)
#define kLC500X_MIN_INTER_KNEE_GAP_2                (1280)              ///< Multi slope minimum inter knee gap 2 (FOT_TS*4: 320*4)

typedef struct kLc500xInfoClass
{
    kCameraInfoClass base;
    k32u placeholder;
} kLc500xInfoClass;

kDeclareClassEx(kFs, kLc500xInfo, kCameraInfo)

kFsFx(kStatus) kLc500xInfo_Init(kLc500xInfo info, kType type, kCameraModel model, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc alloc);
kFsFx(kStatus) kLc500xInfo_VRelease(kLc500xInfo info);

kFsFx(kBool) kLc500xInfo_VHasGainChannel(kCameraInfo info, kCameraGain channel);
kFsFx(k32u) kLc500xInfo_VMaxGainStep(kCameraInfo info, kCameraGain channel);
kFsFx(k32u) kLc500xInfo_VGainStep(kLc500xInfo info, kCameraGain channel, k64f gain);
kFsFx(k64f) kLc500xInfo_VGainFactor(kLc500xInfo info, kCameraGain channel, k32u index);

kFsFx(k32u) kLc500xInfo_DigitalGainStep(kLc500xInfo info, k64f gain);
kFsFx(k64f) kLc500xInfo_DigitalGainFactor(kLc500xInfo info, k32u index);
kFsFx(k32u) kLc500xInfo_ColorGainStep(kLc500xInfo info, k64f gain);
kFsFx(k64f) kLc500xInfo_ColorGainFactor(kLc500xInfo info, k32u index);

kFsFx(k64f) kLc500xInfo_FrameOverheadTime(kLc500xInfo info, k64f pixelPeriod, kBool gammaEnabled);
kFsFx(k64f) kLc500xInfo_RowTime(kLc500xInfo info, k32u pixelCount, k64f pixelPeriod, kBool gammaEnabled);
kFsFx(k64f) kLc500xInfo_MinInterKneeGap(kLc500xInfo info, kSize slopeIndex, k64f pixelPeriod);
kFsFx(k64f) kLc500xInfo_MinGammaExposure(kLc500xInfo info, k64f pixelPeriod, const kPoint64f* kneePoints, kSize kneeCount);

kFsFx(k64f) kLc500xInfo_ReadoutTime(kLc500xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc500xInfo_VReadoutTime(kLc500xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc500xInfo_VMinInterExposureGap(kLc500xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc500xInfo_VMinInterReadoutGap(kLc500xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc500xInfo_VMinExposure(kLc500xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc500xInfo_VMaxExposure(kLc500xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc500xInfo_VPreExposure(kLc500xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc500xInfo_VPostExposure(kLc500xInfo info, const kCameraInfoParams* params);

#endif
