/** 
 * @file    kCameraDynFpn.h
 * @brief   Declares the kCameraDynFpn type. 
 *
 * @internal
 * Copyright (C) 2017-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_DYN_FPN_H
#define K_FIRESYNC_CAMERA_DYN_FPN_H

#include <kFireSync/Client/Camera/Extensions/kCameraExt.h>

/**
 * @class   kCameraDynFpn
 * @extends kCameraExt
 * @ingroup kFireSync-Client-Camera-Extensions
 * @brief   Represents parameters for a camera dynamic FPN extension. 
 * 
 * When this extension is enabled, images can be routed from the pipe back to the camera via the 
 * "DynFpn" camera input port. When an image is received, it replaces the current FPN image 
 * used by PL. Each dynamic FPN message should be structured as a kMsg object containing a kImage.
 * 
 * Dynamic FPN cannot be used simultaneously with RAM Image.
 * 
 */
//typedef kCameraExt kCameraDynFpn;            --forward-declared in kFsDef.x.h

#include <kFireSync/Client/Camera/Extensions/kCameraDynFpn.x.h>

#endif
