/** 
 * @file    kSobelvAccgdwInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_SOBELV_ACCGDW_INFO_X_H
#define K_FIRESYNC_SOBELV_ACCGDW_INFO_X_H

#define kSOBELV_ACCGDW_INFO_DEFAULT_EDGE_WINDOW     (5)
#define kSOBELV_ACCGDW_INFO_MIN_EDGE_WINDOW         (5)
#define kSOBELV_ACCGDW_INFO_MAX_EDGE_WINDOW         (17)

#define kSOBELV_ACCGDW_INFO_MIN_EDGE_THRESHOLD      (1)       //PL docs note that a hardware bug prevents zero from being viable with this config 
#define kSOBELV_ACCGDW_INFO_MAX_EDGE_THRESHOLD      (127)

#define kSOBELV_ACCGDW_INFO_WIDTH_LIMIT             (127)

#define kSOBELV_ACCGDW_INFO_CG_SCALE_SHIFT          (2)

typedef struct kSobelvAccgdwInfoClass
{
    kAcgInfoClass base; 
} kSobelvAccgdwInfoClass; 

kDeclareClassEx(kFs, kSobelvAccgdwInfo, kAcgInfo)

kFsFx(kStatus) xkSobelvAccgdwInfo_ConstructFramework(kSobelvAccgdwInfo* info, kAlloc allocator);

kFsFx(kStatus) kSobelvAccgdwInfo_Init(kSobelvAccgdwInfo info, kType type, kCameraCapability capabilities, k32u plConfig, kVersion plVersion, kAlloc alloc); 

kFsFx(kStatus) kSobelvAccgdwInfo_VInitRead(kSobelvAccgdwInfo info, kType type, kCameraCapability capabilities, k32u plConfig, kVersion plVersion, kXml xml, kXmlItem item, kAlloc alloc);

kFsFx(kCameraAlgorithm) kSobelvAccgdwInfo_VId(kSobelvAccgdwInfo info); 
kFsFx(kType) kSobelvAccgdwInfo_VItemType(kSobelvAccgdwInfo info); 

kFsFx(kBool) kSobelvAccgdwInfo_VIsRowBased(kSobelvAccgdwInfo info);
kFsFx(kSize) kSobelvAccgdwInfo_VCgScale(kSobelvAccgdwInfo info);

/* 
* Deprecated (Stage 1): not recommended for further use, but not yet announced via kDeprecate
*/

//Deprecated: use kAcgInfo_EnableRanges
#define kSobelvAccgdwInfo_EnableRanges kAcgInfo_EnableRanges
//kDeprecate(kSobelvAccgdwInfo_EnableRanges)

//Deprecated: use kAcgInfo_RangesEnabled
#define kSobelvAccgdwInfo_RangesEnabled kAcgInfo_RangesEnabled
//kDeprecate(kSobelvAccgdwInfo_RangesEnabled)

//Deprecated: use kAcgInfo_RangesEnabledInfo
#define kSobelvAccgdwInfo_RangesEnabledInfo kAcgInfo_RangesEnabledInfo
//kDeprecate(kSobelvAccgdwInfo_RangesEnabledInfo)

//Deprecated: use kSobelvAccgdwInfo_SetEdgeThreshold
#define kSobelvAccgdwInfo_SetThreshold1 kSobelvAccgdwInfo_SetEdgeThreshold
//kDeprecate(kSobelvAccgdwInfo_SetThreshold1)

//Deprecated: use kSobelvAccgdwInfo_EdgeThreshold
#define kSobelvAccgdwInfo_Threshold1 kSobelvAccgdwInfo_EdgeThreshold
//kDeprecate(kSobelvAccgdwInfo_Threshold1)

//Deprecated: use kSobelvAccgdwInfo_EdgeThresholdInfo
#define kSobelvAccgdwInfo_Threshold1Info kSobelvAccgdwInfo_EdgeThresholdInfo
//kDeprecate(kSobelvAccgdwInfo_Threshold1Info)

//Deprecated: use kSobelvAccgdwInfo_SetWidthIntensityThreshold
#define kSobelvAccgdwInfo_SetWidthThreshold kSobelvAccgdwInfo_SetWidthIntensityThreshold
//kDeprecate(kSobelvAccgdwInfo_SetWidthThreshold)

//Deprecated: use kSobelvAccgdwInfo_WidthIntensityThreshold
#define kSobelvAccgdwInfo_WidthThreshold kSobelvAccgdwInfo_WidthIntensityThreshold
//kDeprecate(kSobelvAccgdwInfo_WidthThreshold)

//Deprecated: use kSobelvAccgdwInfo_WidthIntensityThresholdInfo
#define kSobelvAccgdwInfo_WidthThresholdInfo kSobelvAccgdwInfo_WidthIntensityThresholdInfo
//kDeprecate(kSobelvAccgdwInfo_WidthThresholdInfo)

#endif
