/** 
 * @file    kTimerBlockInfo.h
 * @brief   Declares the kTimerBlockInfo class. 
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_TIMER_BLOCK_INFO_H
#define K_FIRESYNC_TIMER_BLOCK_INFO_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kTimerBlockInfo
 * @extends kObject
 * @ingroup kFireSync-Blocks
 * @brief   Represents configuration for kTimerBlock. 
 */
//typedef kObject kTimerBlockInfo;        --forward-declared in kFsDef.x.h

/** 
 * Constructs a kTimerBlockInfo object. 
 *
 * @public              @memberof kTimerBlockInfo
 * @param   info        Receives constructed info object. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
 kFsFx(kStatus) kTimerBlockInfo_Construct(kTimerBlockInfo* info, kAlloc allocator); 

/** 
 * Constructs a kTimerBlockInfo object and loads its content from an XML object. 
 *
 * @public              @memberof kTimerBlockInfo
 * @param   info        Receives constructed info object.  
 * @param   xml         Source from which parameters are loaded. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kTimerBlockInfo_Load(kTimerBlockInfo* info, kXml xml, kAlloc allocator); 

/** 
 * Constructs a kXml object and uses it to store the content of this kTimerBlockInfo instance.
 *
 * @public              @memberof kTimerBlockInfo
 * @param   info        Info object.  
 * @param   xml         Receives constructed kXml object.
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kTimerBlockInfo_Store(kTimerBlockInfo info, kXml* xml, kAlloc allocator); 

/** 
 * Reads kTimerBlockInfo state from a kXml object. 
 *
 * @public              @memberof kTimerBlockInfo
 * @param   info        Info object.  
 * @param   xml         XML object. 
 * @param   item        XML item.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kTimerBlockInfo_Read(kTimerBlockInfo info, kXml xml, kXmlItem item); 

/** 
 * Writes kTimerBlockInfo state to a kXml object. 
 *
 * @public              @memberof kTimerBlockInfo
 * @param   info        Info object.  
 * @param   xml         XML object. 
 * @param   item        XML item.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kTimerBlockInfo_Write(kTimerBlockInfo info, kXml xml, kXmlItem item); 

/** 
 * Checks and automatically corrects all state variables. 
 *
 * @public              @memberof kTimerBlockInfo
 * @param   info        Info object.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kTimerBlockInfo_Validate(kTimerBlockInfo info); 

/** 
 * Resets all state variables to default values.
 *
 * @public              @memberof kTimerBlockInfo
 * @param   info        Info object.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kTimerBlockInfo_Clear(kTimerBlockInfo info); 

/** 
 * Sets the timer period.
 *
 * @public              @memberof kTimerBlockInfo
 * @param   info        Info object.  
 * @param   period      Timer period, in microseconds.
 * @return              Operation status. 
 */
kFsFx(kStatus) kTimerBlockInfo_SetPeriod(kTimerBlockInfo info, k64u period); 

/** 
 * Gets the timer period.
 *
 * @public              @memberof kTimerBlockInfo
 * @param   info        Info object.  
 * @return              Timer period, in microseconds.
 */
kFsFx(k64u) kTimerBlockInfo_Period(kTimerBlockInfo info); 

/** Gets the output port id for this block type. */
kInlineFx(k16u) kTimerBlockInfo_OutputId() { return (k16u) 0; }

#include <kFireSync/Blocks/kTimerBlockInfo.x.h>

#endif
