/** 
 * @file    kMemoryTrafficBlockInfo.h
 * @brief   Declares the kMemoryTrafficBlockInfo class. 
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MEMORY_TRAFFIC_BLOCK_INFO_H
#define K_FIRESYNC_MEMORY_TRAFFIC_BLOCK_INFO_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kMemoryTrafficBlockInfo
 * @extends kObject
 * @ingroup kFireSync-Blocks
 * @brief   Represents configuration for kMemoryTrafficBlock. 
 */
//typedef kObject kMemoryTrafficBlockInfo;        --forward-declared in kFsDef.x.h

/** 
 * Constructs a kMemoryTrafficBlockInfo object. 
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Receives constructed info object. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
 kFsFx(kStatus) kMemoryTrafficBlockInfo_Construct(kMemoryTrafficBlockInfo* info, kAlloc allocator); 

/** 
 * Constructs a kMemoryTrafficBlockInfo object and loads its content from an XML object. 
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Receives constructed info object.  
 * @param   xml         Source from which parameters are loaded. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficBlockInfo_Load(kMemoryTrafficBlockInfo* info, kXml xml, kAlloc allocator); 

/** 
 * Constructs a kXml object and uses it to store the content of this kMemoryTrafficBlockInfo instance.
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.  
 * @param   xml         Receives constructed kXml object.
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficBlockInfo_Store(kMemoryTrafficBlockInfo info, kXml* xml, kAlloc allocator); 

/** 
 * Reads kMemoryTrafficBlockInfo state from a kXml object. 
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.  
 * @param   xml         XML object. 
 * @param   item        XML item.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficBlockInfo_Read(kMemoryTrafficBlockInfo info, kXml xml, kXmlItem item); 

/** 
 * Writes kMemoryTrafficBlockInfo state to a kXml object. 
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.  
 * @param   xml         XML object. 
 * @param   item        XML item.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficBlockInfo_Write(kMemoryTrafficBlockInfo info, kXml xml, kXmlItem item); 

/** 
 * Checks and automatically corrects all state variables. 
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficBlockInfo_Validate(kMemoryTrafficBlockInfo info); 

/** 
 * Resets all state variables to default values.
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficBlockInfo_Clear(kMemoryTrafficBlockInfo info); 

/** 
 * Gets the buffer size in bytes.
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.  
 * @return              Size of buffer allocated.
 */
kFsFx(kSize) kMemoryTrafficBlockInfo_BufferSize(kMemoryTrafficBlockInfo info);

/**
 * Gets the number of bytes to manipulate.
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.
 * @return              Number of bytes to manipulate.
 */
kFsFx(k64u) kMemoryTrafficBlockInfo_ByteCount(kMemoryTrafficBlockInfo info);

/**
 * Gets the operation type.
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.
 * @return              Operation type.
 */
kFsFx(kMemoryTrafficOp) kMemoryTrafficBlockInfo_Operation(kMemoryTrafficBlockInfo info);

/**
 * Sets the buffer size in bytes.
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.
 * @param   bufferSize  Requested buffer size.
 * @return              Operation status.
 */
kFsFx(kStatus) kMemoryTrafficBlockInfo_SetBufferSize(kMemoryTrafficBlockInfo info, kSize bufferSize);

/**
 * Sets the operation type.
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.
 * @param   operation   Operation type.
 * @return              Operation status.
 */
kFsFx(kStatus) kMemoryTrafficBlockInfo_SetOperation(kMemoryTrafficBlockInfo info, kMemoryTrafficOp operation);

/**
 * Sets the requested number of bytes to be manipulated by the operation.
 *
 * @public              @memberof kMemoryTrafficBlockInfo
 * @param   info        Info object.
 * @param   byteCount   Number of bytes to manipulate.
 * @return              Operation status.
 */
kFsFx(kStatus) kMemoryTrafficBlockInfo_SetByteCount(kMemoryTrafficBlockInfo info, k64u byteCount);

/** Gets the input port id. */
kInlineFx(k16u) kMemoryTrafficBlockInfo_InputPortId() { return 0; }

/** Gets the output port id. */
kInlineFx(k16u) kMemoryTrafficBlockInfo_OutputPortId() { return 1; }

#include <kFireSync/Blocks/kMemoryTrafficBlockInfo.x.h>

#endif
