/** 
 * @file    kMemoryDomainBlockInfo.x.h
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MEMORY_DOMAIN_BLOCK_INFO_X_H
#define K_FIRESYNC_MEMORY_DOMAIN_BLOCK_INFO_X_H

kDeclareEnumEx(kFs, kMemoryDomainBlockOutput, kValue)

typedef struct kMemoryDomainBlockInfoClass
{
    kObjectClass base; 
    kBool forceCloneEnabled;                      //Should the block always clone, or sniff incoming memory? 
    kMemoryDomainBlockOutput outputMemory;        //Output memory type.
} kMemoryDomainBlockInfoClass; 

kDeclareClassEx(kFs, kMemoryDomainBlockInfo, kObject)
        
kFsFx(kStatus) kMemoryDomainBlockInfo_Init(kMemoryDomainBlockInfo info, kType type, kAlloc alloc); 
kFsFx(kStatus) kMemoryDomainBlockInfo_VRelease(kMemoryDomainBlockInfo info); 

#endif
