/** 
 * @file    kMemoryDomainBlock.x.h
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MEMORY_DOMAIN_BLOCK_X_H
#define K_FIRESYNC_MEMORY_DOMAIN_BLOCK_X_H

#include <kFireSync/Pipe/kPxBlock.h>

typedef struct kMemoryDomainBlockClass
{
    kPxBlockClass base; 
    kMemoryDomainBlockInfo info;          //Block settings.
    kPxPort outputPort;                   //Output port.
    kAlloc valueAlloc;                    //Value allocator used when cloning. 
    kObject copyContext;                  //Context object for copy operations (optional).
} kMemoryDomainBlockClass; 

kDeclareClassEx(kFs, kMemoryDomainBlock, kPxBlock)

kFsFx(const kChar*) kMemoryDomainBlock_VDescription(); 

kFsFx(kStatus) kMemoryDomainBlock_VOnSetup(kMemoryDomainBlock block);
kFsFx(kStatus) kMemoryDomainBlock_VOnStart(kMemoryDomainBlock block);
kFsFx(kStatus) kMemoryDomainBlock_VOnStop(kMemoryDomainBlock block);
kFsFx(kStatus) kMemoryDomainBlock_VOnReceive(kMemoryDomainBlock block, kPxPort port, kMsgSet msg);

#endif
