/** 
 * @file    kLc250xFpnBlockInfo.x.h
 *
 * @internal
 * Copyright (C) by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC250X_FPN_BLOCK_INFO_X_H
#define K_FIRESYNC_LC250X_FPN_BLOCK_INFO_X_H

typedef struct kLc250xFpnBlockInfoClass
{
    kObjectClass base; 
    k32u calibrationMode;       //0: Disabled
                                //1: OB rows with HFPN
                                //2: OB rows without HFPN
                                //3: Active rows with HFPN
                                //4: Active rows without HFPN
    kBool hfpnEnabled;
    kBool vfpnEnabled;
} kLc250xFpnBlockInfoClass; 

kDeclareClassEx(kFs, kLc250xFpnBlockInfo, kObject)
        
kFsFx(kStatus) kLc250xFpnBlockInfo_Init(kLc250xFpnBlockInfo info, kType type, kAlloc alloc); 
kFsFx(kStatus) kLc250xFpnBlockInfo_VRelease(kLc250xFpnBlockInfo info); 

#endif
