/** 
 * @file    kInvertBlockInfo.x.h
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_INVERT_BLOCK_INFO_X_H
#define K_FIRESYNC_INVERT_BLOCK_INFO_X_H


kDeclareEnumEx(kFs, kInvertBlockAlgorithm, kValue)
kDeclareEnumEx(kFs, kInvertBlockMemory, kValue)

typedef struct kInvertBlockInfoClass
{
    kObjectClass base; 
    kBool enabled;                          //Is the block enabled? 
    kInvertBlockAlgorithm algorithm;        //Algorithm to be used.
    kInvertBlockMemory memory;              //Output memory type.
} kInvertBlockInfoClass; 

kDeclareClassEx(kFs, kInvertBlockInfo, kObject)
        
kFsFx(kStatus) kInvertBlockInfo_Init(kInvertBlockInfo info, kType type, kAlloc alloc); 
kFsFx(kStatus) kInvertBlockInfo_VRelease(kInvertBlockInfo info); 

#endif
