/** 
 * @file    kForwardBlock.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_FORWARD_BLOCK_X_H
#define K_FIRESYNC_FORWARD_BLOCK_X_H

#include <kFireSync/Pipe/kPxBlock.h>

typedef struct kForwardBlockClass
{
    kPxBlockClass base; 
    kForwardBlockInfo info;         //Settings. 
    kArrayList outputPorts;         //List of output ports -- kArrayList<kPxPort>.    
} kForwardBlockClass; 

kDeclareClassEx(kFs, kForwardBlock, kPxBlock)

kFsFx(const kChar*) kForwardBlock_VDescription(); 

kFsFx(kStatus) kForwardBlock_VOnSetup(kForwardBlock block);
kFsFx(kStatus) kForwardBlock_VOnStart(kForwardBlock block);
kFsFx(kStatus) kForwardBlock_VOnStop(kForwardBlock block);
kFsFx(kStatus) kForwardBlock_VOnReceive(kForwardBlock block, kPxPort port, kMsgSet msg);

#endif
