/** 
 * @file    kInvertHost.x.h
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_INVERT_HOST_X_H
#define K_FIRESYNC_INVERT_HOST_X_H

#include <kFireSync/Blocks/Details/kInvertAlg.h>

typedef struct kInvertHostClass
{
    kInvertAlgClass base; 
} kInvertHostClass; 

kDeclareClassEx(kFs, kInvertHost, kInvertAlg)
        
kFsFx(kStatus) kInvertHost_Construct(kInvertHost* algorithm,  const kInvertAlgParams* params, kAlloc allocator); 

kFsFx(kStatus) kInvertHost_Init(kInvertHost algorithm, kType type, const kInvertAlgParams* params, kAlloc alloc); 

kFsFx(kStatus) kInvertHost_VExecute(kInvertAlg algorithm, kImage input, kBool inputExclusive, kImage* output);

#endif
