/** 
 * @file    kInvertCuda.x.h
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_INVERT_CUDA_X_H
#define K_FIRESYNC_INVERT_CUDA_X_H

#include <kFireSync/Blocks/Details/kInvertAlg.h>

typedef struct kInvertCudaClass
{
    kInvertAlgClass base; 
    kCudaStream stream; 
} kInvertCudaClass; 

kDeclareClassEx(kFs, kInvertCuda, kInvertAlg)

kFsFx(kStatus) kInvertCuda_Construct(kInvertCuda* algorithm,  const kInvertAlgParams* params, kAlloc allocator); 

kFsFx(kStatus) kInvertCuda_Init(kInvertCuda algorithm, kType type, const kInvertAlgParams* params, kAlloc alloc); 
kFsFx(kStatus) kInvertCuda_VRelease(kInvertCuda algorithm);

kFsFx(kStatus) kInvertCuda_VExecute(kInvertAlg algorithm, kImage input, kBool inputExclusive, kImage* output);


#endif
