/** 
 * @file    kStartActionInfo.h
 * @brief   Declares the kStartActionInfo class. 
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_START_ACTION_INFO_H
#define K_FIRESYNC_START_ACTION_INFO_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kStartActionInfo
 * @extends kObject
 * @ingroup kFireSync-Actions
 * @brief   Represents configuration for kStartAction. 
 */
//typedef kObject kStartActionInfo;        --forward-declared in kFsDef.x.h

/** 
 * Constructs a kStartActionInfo object. 
 *
 * @public              @memberof kStartActionInfo
 * @param   info        Receives constructed info object. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
 kFsFx(kStatus) kStartActionInfo_Construct(kStartActionInfo* info, kAlloc allocator); 

/** 
 * Constructs a kStartActionInfo object and loads its content from an XML object. 
 *
 * @public              @memberof kStartActionInfo
 * @param   info        Receives constructed info object.  
 * @param   xml         Source from which parameters are loaded. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kStartActionInfo_Load(kStartActionInfo* info, kXml xml, kAlloc allocator); 

/** 
 * Constructs a kXml object and uses it to store the content of this kStartActionInfo instance.
 *
 * @public              @memberof kStartActionInfo
 * @param   info        Info object.  
 * @param   xml         Receives constructed kXml object.
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kStartActionInfo_Store(kStartActionInfo info, kXml* xml, kAlloc allocator); 

/** 
 * Reads kStartActionInfo state from a kXml object. 
 *
 * @public              @memberof kStartActionInfo
 * @param   info        Info object.  
 * @param   xml         XML object. 
 * @param   item        XML item.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kStartActionInfo_Read(kStartActionInfo info, kXml xml, kXmlItem item); 

/** 
 * Writes kStartActionInfo state to a kXml object. 
 *
 * @public              @memberof kStartActionInfo
 * @param   info        Info object.  
 * @param   xml         XML object. 
 * @param   item        XML item.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kStartActionInfo_Write(kStartActionInfo info, kXml xml, kXmlItem item); 

/** 
 * Checks and automatically corrects all state variables. 
 *
 * @public              @memberof kStartActionInfo
 * @param   info        Info object.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kStartActionInfo_Validate(kStartActionInfo info); 

/** 
 * Resets all state variables to default values.
 *
 * @public              @memberof kStartActionInfo
 * @param   info        Info object.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kStartActionInfo_Clear(kStartActionInfo info); 

/** 
 * Determines whether this action will start the system or only the local node.
 *
 * @public              @memberof kStartActionInfo
 * @param   info        Info object.  
 * @param   startAll    If kTRUE all nodes will be started; else the local node will be started. 
 * @return              Operation status. 
 */
kFsFx(kStatus) kStartActionInfo_EnableStartAll(kStartActionInfo info, kBool startAll); 

/** 
 * Reports whether this action will start the system or only the local node.
 *
 * @public              @memberof kStartActionInfo
 * @param   info        Info object.  
 * @return              kTRUE if all nodes will be started; otherwise kFALSE. 
 */
kFsFx(kBool) kStartActionInfo_StartAll(kStartActionInfo info); 

#include <kFireSync/Actions/kStartActionInfo.x.h>

#endif
