/** 
 * @file    kMemoryTrafficWorker.h
 * @brief   Declares the kMemoryTrafficWorker class. 
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MEMORY_TRAFFIC_WORKER_H
#define K_FIRESYNC_MEMORY_TRAFFIC_WORKER_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kMemoryTrafficWorker
 * @extends kObject
 * @ingroup kFireSync-Utils
 * @brief   Represents helper class to kMemoryTrafficAction.
 *
 */
//typedef kObject kMemoryTrafficWorker;        --forward-declared in kFsDef.x.h

kFsFx(kStatus) kMemoryTrafficWorker_Construct(kMemoryTrafficWorker* worker, kSize bufferSize, kMemoryTrafficOp operation, kSize threadCount, kObject allocator);

/**
 * Terminates running threads.
 *
 * @public              @memberof kMemoryTrafficWorker
 * @param   worker      kMemoryTrafficWorker object.
 * @return              Number of active threads performing an operation.
 */
kFsFx(kStatus) kMemoryTrafficWorker_TerminateThreads(kMemoryTrafficWorker worker);

/**
 * Reports throughput statistics on display.
 *
 * @public              @memberof kMemoryTrafficWorker
 * @param   worker      kMemoryTrafficWorker object.
 * @return              Operation status.
 */
kFsFx(kStatus) kMemoryTrafficWorker_Report(kMemoryTrafficWorker worker);

/**
 * Generates an XML file with throughput statistics.
 *
 * @public              @memberof kMemoryTrafficWorker
 * @param   worker      kMemoryTrafficWorker object.
 * @param   output      XML output file.
 * @return              Operation status.
 */
kFsFx(kStatus) kMemoryTrafficWorker_GenerateXml(kMemoryTrafficWorker worker, kXml* output);

#include <kFireSync/Actions/kMemoryTrafficWorker.x.h>

#endif
