/** 
 * @file    kMemoryTrafficActionInfo.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MEMORY_TRAFFIC_ACTION_INFO_X_H
#define K_FIRESYNC_MEMORY_TRAFFIC_ACTION_INFO_X_H

#define kMEMORY_TRAFFIC_ACTION_INFO_DEFAULT_THREAD_COUNT        (1)
#define kMEMORY_TRAFFIC_ACTION_INFO_DEFAULT_BUFFER_SIZE         (4000000)

typedef struct kMemoryTrafficActionInfoClass
{
    kObjectClass base; 
    kSize bufferSize; 
    kSize threadCount;
    kMemoryTrafficOp operation;
} kMemoryTrafficActionInfoClass; 

kDeclareClassEx(kFs, kMemoryTrafficActionInfo, kObject)
        
kFsFx(kStatus) kMemoryTrafficActionInfo_Init(kMemoryTrafficActionInfo info, kType type, kAlloc alloc); 
kFsFx(kStatus) kMemoryTrafficActionInfo_VRelease(kMemoryTrafficActionInfo info); 

#endif
