/** 
 * @file    kMemoryTrafficAction.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MEMORY_TRAFFIC_ACTION_X_H
#define K_FIRESYNC_MEMORY_TRAFFIC_ACTION_X_H

#include <kFireSync/Action/kAxAction.h>

typedef struct kMemoryTrafficActionClass
{
    kAxActionClass base; 
    kMemoryTrafficActionInfo info;
} kMemoryTrafficActionClass; 

kDeclareClassEx(kFs, kMemoryTrafficAction, kAxAction)

kFsFx(const kChar*) kMemoryTrafficAction_VDescription(); 

kFsFx(kStatus) kMemoryTrafficAction_VValidate(kXml settings, kAlloc alloc); 
kFsFx(kStatus) kMemoryTrafficAction_VInvoke(kAxAction action, kObject input, kObject* output, kAlloc alloc);

kFsFx(kStatus) kMemoryTrafficAction_StartOperation(kAxAction action, kMemoryTrafficWorker worker, kMemoryTrafficActionInfo info, kMemoryTrafficOp operation);
kFsFx(kStatus) kMemoryTrafficAction_EndOperation(kAxAction action, kMemoryTrafficWorker worker, kObject* output);

#endif
