
ifeq ($(OS)$(os), Windows_NT)
	CROSS_PREFIX := C:/tools/GccX64_4.9.4-p23/x86_64-linux-gnu/bin/x86_64-linux-gnu-
	CROSS_SUFFIX := .exe
	PYTHON := python
	MKDIR_P := $(PYTHON) ../../../Platform/scripts/Utils/kUtil.py mkdir_p
	RM_F := $(PYTHON) ../../../Platform/scripts/Utils/kUtil.py rm_f
	RM_RF := $(PYTHON) ../../../Platform/scripts/Utils/kUtil.py rm_rf
	CP := $(PYTHON) ../../../Platform/scripts/Utils/kUtil.py cp
else
	BUILD_MACHINE := $(shell uname -m)
	ifneq ($(BUILD_MACHINE), x86_64)
		CROSS_PREFIX := /tools/GccX64_4.9.4-p23/x86_64-linux-gnu/bin/x86_64-linux-gnu-
		CROSS_SUFFIX := 
	endif
	PYTHON := python3
	MKDIR_P := mkdir -p
	RM_F := rm -f
	RM_RF := rm -rf
	CP := cp
endif

C_COMPILER := $(CROSS_PREFIX)gcc$(CROSS_SUFFIX)
CXX_COMPILER := $(CROSS_PREFIX)g++$(CROSS_SUFFIX)
LINKER := $(CROSS_PREFIX)g++$(CROSS_SUFFIX)
ARCHIVER := $(CROSS_PREFIX)ar$(CROSS_SUFFIX)
GNU_READELF := $(CROSS_PREFIX)readelf$(CROSS_SUFFIX)
APP_GEN := $(PYTHON) ../../../Platform/scripts/Utils/kAppGen.py

ifndef verbose
	SILENT := @
endif

ifndef config
	config := Debug
endif

# We require tools to be installed according to specific conventions (see manuals).
# Tool prerequisites may change between major releases; check and report.
ifeq ($(shell $(C_COMPILER) --version),)
.PHONY: tc_err
tc_err:
	$(error Cannot build because of missing prerequisite; please install)
endif

ifeq ($(config),Debug)
	TARGET := ../../../lib/linux_x64d/libgtest_main.a
	INTERMEDIATES := 
	OBJ_DIR := ../../../build/gtest_main-gnumk_linux_x64-Debug
	PREBUILD := 
	POSTBUILD := 
	COMPILER_FLAGS := -g -march=x86-64 -fpic
	C_FLAGS := -std=gnu99 -Wall -Wno-unused-variable -Wno-unused-parameter -Wno-unused-value -Wno-missing-braces
	CXX_FLAGS := -std=c++14 -Wall -Wfloat-conversion
	INCLUDE_DIRS := -I../../extern/googletest/package/googletest -I../../extern/googletest/package/googletest/include
	DEFINES := -DGTEST_HAS_PTHREAD=0 -D_HAS_EXCEPTIONS=1
	LINKER_FLAGS :=
	LIB_DIRS := -L../../../lib/linux_x64d
	LIBS :=
	LDFLAGS := $(LINKER_FLAGS) $(LIBS) $(LIB_DIRS)

	OBJECTS := ../../../build/gtest_main-gnumk_linux_x64-Debug/gtest_main.cc.o
	DEP_FILES = ../../../build/gtest_main-gnumk_linux_x64-Debug/gtest_main.cc.d
	TARGET_DEPS = ./../../../lib/linux_x64d/libgtest.a

endif

ifeq ($(config),Release)
	TARGET := ../../../lib/linux_x64/libgtest_main.a
	INTERMEDIATES := 
	OBJ_DIR := ../../../build/gtest_main-gnumk_linux_x64-Release
	PREBUILD := 
	POSTBUILD := 
	COMPILER_FLAGS := -O2 -march=x86-64 -fpic
	C_FLAGS := -std=gnu99 -Wall -Wno-unused-variable -Wno-unused-parameter -Wno-unused-value -Wno-missing-braces
	CXX_FLAGS := -std=c++14 -Wall -Wfloat-conversion
	INCLUDE_DIRS := -I../../extern/googletest/package/googletest -I../../extern/googletest/package/googletest/include
	DEFINES := -DGTEST_HAS_PTHREAD=0 -D_HAS_EXCEPTIONS=1
	LINKER_FLAGS :=
	LIB_DIRS := -L../../../lib/linux_x64
	LIBS :=
	LDFLAGS := $(LINKER_FLAGS) $(LIBS) $(LIB_DIRS)

	OBJECTS := ../../../build/gtest_main-gnumk_linux_x64-Release/gtest_main.cc.o
	DEP_FILES = ../../../build/gtest_main-gnumk_linux_x64-Release/gtest_main.cc.d
	TARGET_DEPS = ./../../../lib/linux_x64/libgtest.a

endif

ifdef profile
	COMPILER_FLAGS += -pg
	LDFLAGS += -pg
endif

ifdef coverage
	COMPILER_FLAGS += --coverage -fprofile-arcs -ftest-coverage
	LDFLAGS += --coverage
	LIBS += -lgcov
endif

ifdef sanitize
	COMPILER_FLAGS += -fsanitize=$(sanitize)
	LDFLAGS += -fsanitize=$(sanitize)
endif

.PHONY: all all-obj all-dep clean

all: $(OBJ_DIR)
	$(PREBUILD)
	$(SILENT) $(MAKE) -f gtest_main-Linux_X64.mk all-dep
	$(SILENT) $(MAKE) -f gtest_main-Linux_X64.mk all-obj

clean:
	$(SILENT) $(info Cleaning $(OBJ_DIR))
	$(SILENT) $(RM_RF) $(OBJ_DIR)
	$(SILENT) $(info Cleaning $(TARGET) $(INTERMEDIATES))
	$(SILENT) $(RM_F) $(TARGET) $(INTERMEDIATES)

all-obj: $(OBJ_DIR) $(TARGET)
all-dep: $(OBJ_DIR) $(DEP_FILES)

$(OBJ_DIR):
	$(SILENT) $(MKDIR_P) $@

ifeq ($(config),Debug)

$(TARGET): $(OBJECTS) $(TARGET_DEPS)
	$(SILENT) $(info ArX64 $(TARGET))
	$(SILENT) $(RM_F) $(TARGET)
	$(SILENT) $(ARCHIVER) rcs $(TARGET) $(OBJECTS)

endif

ifeq ($(config),Release)

$(TARGET): $(OBJECTS) $(TARGET_DEPS)
	$(SILENT) $(info ArX64 $(TARGET))
	$(SILENT) $(RM_F) $(TARGET)
	$(SILENT) $(ARCHIVER) rcs $(TARGET) $(OBJECTS)

endif

ifeq ($(config),Debug)

../../../build/gtest_main-gnumk_linux_x64-Debug/gtest_main.cc.o ../../../build/gtest_main-gnumk_linux_x64-Debug/gtest_main.cc.d: ../../extern/googletest/package/googletest/src/gtest_main.cc
	$(SILENT) $(info GccX64 ../../extern/googletest/package/googletest/src/gtest_main.cc)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../../build/gtest_main-gnumk_linux_x64-Debug/gtest_main.cc.o -c ../../extern/googletest/package/googletest/src/gtest_main.cc -MMD -MP

endif

ifeq ($(config),Release)

../../../build/gtest_main-gnumk_linux_x64-Release/gtest_main.cc.o ../../../build/gtest_main-gnumk_linux_x64-Release/gtest_main.cc.d: ../../extern/googletest/package/googletest/src/gtest_main.cc
	$(SILENT) $(info GccX64 ../../extern/googletest/package/googletest/src/gtest_main.cc)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../../build/gtest_main-gnumk_linux_x64-Release/gtest_main.cc.o -c ../../extern/googletest/package/googletest/src/gtest_main.cc -MMD -MP

endif

ifeq ($(MAKECMDGOALS),all-obj)

ifeq ($(config),Debug)

include ../../../build/gtest_main-gnumk_linux_x64-Debug/gtest_main.cc.d

endif

ifeq ($(config),Release)

include ../../../build/gtest_main-gnumk_linux_x64-Release/gtest_main.cc.d

endif

endif

