#ifndef GV_MESH_MSG_X_H
#define GV_MESH_MSG_X_H

#include <kVision/L3d/kL3dTransform3d.h>

kDeclareValueEx(Gv, GvFacet32u, kValue)

// Each of vertex1, vertex2, vertex3 represents the the vertex index in count-clockwise direction
// Note each vertex index must be valid index from corresponding vertex data channel
typedef struct GvFacet32u
{
    k32u vertex1;    //  Index of first vertex
    k32u vertex2;    //  Index of second vertex
    k32u vertex3;    //  Index of third vertex
} GvFacet32u; 

kDeclareValueEx(Gv, GvMeshMsgChannel, kValue)

typedef struct GvMeshMsgChannel
{
    GvMeshMsgChannelId id;          //  channel id
    GvMeshMsgChannelType type;      //  Type of channel
    GvMeshMsgChannelState state;    //  State of channel
    k32u flag;                      //  User specified channel flag
    kSize allocatedCount;           //  Allocated buffer size
    kSize dataCount;                //  Actual used buffer size
    kType dataType;                 //  buffer data type
    kArray1 buffer;                 //  buffer, type of dataType
} GvMeshMsgChannel;

typedef struct GvMeshMsgClass
{
    GvDataMsgClass base;
 
    kBool hasData;                                                      //  Whether any channel buffer has been allocated
    kSize maxUserChannel;                                               //  Max number of user channels allowed
    kSize numOfUserChannel;                                             //  Number of additional (non-system) channels

    kPoint3d64f offset;                                                 //  Object center
    kPoint3d64f range;                                                  //  Object dimension
 
    kL3dTransform3d transform;                                          //  Transformation matrix
 
    GvMeshMsgChannel systemChannels[GV_MESH_MSG_NUM_OF_SYSTEM_CHANNEL]; //  System (default) channels
    kArray1 userChannels;                                               //  kTypeOf(GvMeshMsgLayer)
} GvMeshMsgClass;

kDeclareClassEx(Gv, GvMeshMsg, GvDataMsg)

GvFx(kStatus) GvMeshMsg_Init(GvMeshMsg msg, kAlloc alloc);
GvFx(kStatus) GvMeshMsg_VInitClone(GvMeshMsg msg, GvMeshMsg src, kAlloc alloc);
GvFx(kStatus) GvMeshMsg_VRelease(GvMeshMsg msg);

GvFx(kStatus) GvMeshMsg_WriteDat6V1(GvMeshMsg msg, kSerializer serializer);
GvFx(kStatus) GvMeshMsg_ReadDat6V1(GvMeshMsg msg, kSerializer serializer, kAlloc allocator);

GvFx(GvMeshMsgChannel*) GvMeshMsg_GetChannel(GvMeshMsg msg, GvMeshMsgChannelId id);

GvFx(kStatus) GvMeshMsg_SetChannelStateInt(GvMeshMsg msg, GvMeshMsgChannelId id, GvMeshMsgChannelState state, kBool pass);


#endif //GV_MESH_MSG_X_H
