#ifndef GSA_LIB_SCANNER_G2_PROPERTIES_H
#define GSA_LIB_SCANNER_G2_PROPERTIES_H

#include "ScannerBase.h"
#include "ScannerG1.h"

namespace GoSensorApp
{

namespace GoProp = Go::Properties;

struct Surface : public GoProp::Structure
{
    GoProp::Value<k32s> type;
    GoProp::Value<std::vector<k32s>> typeOptions;

    FixedLength fixedLength;
    VariableLength variableLength;
    Rotational rotational;

    Surface()
    {
        Register("surfaceType", type);
        type.RegisterSchema("enum", typeOptions);

        Register("fixedLength", fixedLength);
        Register("variableLength", variableLength);
        Register("rotational", rotational);
    }
};

struct EdgeFiltering : public GoProp::Structure
{
    GoProp::Value<bool> enabled;
    GoProp::Value<bool> preserveInteriorEnabled;

    MinMaxValue<k64f> elementWidth;
    MinMaxValue<k64f> elementLength;

    EdgeFiltering()
    {
        Register("enabled", enabled);
        Register("preserveInteriorEnabled", preserveInteriorEnabled);

        Register("elementWidth", elementWidth);
        Register("elementLength", elementLength);
    }
};

struct Part : public GoProp::Structure
{
    GoProp::Value<bool> enabled;

    MinMaxValue<k64f> minArea;
    MinMaxValue<k64f> gapWidth;
    MinMaxValue<k64f> gapLength;
    MinMaxValue<k64f> paddingWidth;
    MinMaxValue<k64f> paddingLength;
    MinMaxValue<k64f> minLength;
    MinMaxValue<k64f> maxLength;
    MinMaxValue<k64f> threshold;

    GoProp::Value<k32s> thresholdDirection;
    GoProp::Value<std::vector<k32s>> thresholdDirectionOptions;

    GoProp::Value<bool> includeSinglePointsEnabled;

    EdgeFiltering edgeFiltering;

    Part()
    {
        Register("enabled", enabled);

        Register("minArea", minArea);
        Register("gapWidth", gapWidth);
        Register("gapLength", gapLength);
        Register("paddingWidth", paddingWidth);
        Register("paddingLength", paddingLength);
        Register("minLength", minLength);
        Register("maxLength", maxLength);
        Register("threshold", threshold);
        Register("thresholdDirection", thresholdDirection);
        thresholdDirection.RegisterSchema("enum", thresholdDirectionOptions);

        Register("includeSinglePointsEnabled", includeSinglePointsEnabled);
        
        Register("edgeFiltering", edgeFiltering);
    }
};

struct G2ScannerSchema : public ScannerBase
{
    Surface surface;
    GoProp::Value<bool> surfaceUsed;

    Part part;
    GoProp::Value<bool> partUsed;

    G2ScannerSchema()
    {
        Register("surface", surface);
        surface.RegisterSchema("used", surfaceUsed);

        Register("part", part);
        part.RegisterSchema("used", partUsed);
    }
};

}; // namespaces

#endif
